// Rysunek 19.2. LinearSearchTest.java
// Sekwencyjne przeszukiwanie tablicy w celu znalezienia elementu
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Scanner;

public class LinearSearchTest {
   // Wykonuje liniowe wyszukianie w danych                  
   public static int linearSearch(int data[], int searchKey) {
      // Przejdź przez tablicę sekwencyjnie                     
      for (int index = 0; index < data.length; index++) {     
         if (data[index] == searchKey) {                      
            return index; // Zwróć indeks
         }                                                    
      }                                                       
                                                              
      return -1; // Liczby nie znaleziono                    
   }                                                          

   public static void main(String[] args) {
      Scanner input = new Scanner(System.in);
      SecureRandom generator = new SecureRandom();

      int[] data = new int[10]; // Utworzenie tablicy

      for (int i = 0; i < data.length; i++) { // Wypełnienie tablicy
         data[i] = 10 + generator.nextInt(90);
      }

      System.out.printf("%s%n%n", Arrays.toString(data)); // Wyświetlenie tablicy

      // Pobranie danych od użytkownika
      System.out.print("Wpisz liczbę całkowitą (-1, aby zakończyć): ");
      int searchInt = input.nextInt(); 

      // Pobieranie w pętli liczby całkowitej; -1 przerywa program
      while (searchInt != -1) {
         int position = linearSearch(data, searchInt); // Przeprowadzenie wyszukiwania

         if (position == -1) { // Nie znaleziono
            System.out.printf("%d nie znaleziono%n%n", searchInt); 
         }
         else { // Znaleziono
            System.out.printf("%d znaleziono na pozycji %d%n%n", 
               searchInt, position);
         }

         // Pobranie danych od użytkownika
         System.out.print("Wpisz liczbę całkowitą (-1, aby zakończyć): ");
         searchInt = input.nextInt();
      } 
   } 
} 


/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/