// Rysunek 17.9. IntStreamOperations.java
// Przykład użycia operacji IntStream
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class IntStreamOperations {
   public static void main(String[] args) {
      int[] values = {3, 10, 6, 1, 4, 8, 2, 5, 9, 7};

      // Wyświetlenie oryginalnych wartości
      System.out.print("Oryginalne wartości: ");
      System.out.println(
         IntStream.of(values)
                  .mapToObj(String::valueOf)
                  .collect(Collectors.joining(" ")));

      // Użycie dla wartości metod count, min, max, sum i average
      System.out.printf("%nElementów: %d%n", IntStream.of(values).count());
      System.out.printf("Minimum: %d%n",
         IntStream.of(values).min().getAsInt());
      System.out.printf("Maksimum: %d%n",
         IntStream.of(values).max().getAsInt());
      System.out.printf("Suma: %d%n", IntStream.of(values).sum());
      System.out.printf("Średnia: %.2f%n",
         IntStream.of(values).average().getAsDouble());

      // Suma wartości z wykorzystaniem metody reduce
      System.out.printf("%nSuma poprzez metodę reduce: %d%n",
         IntStream.of(values)
                  .reduce(0, (x, y) -> x + y));

      // Iloczyn wartości z wykorzystaniem metody reduce
      System.out.printf("Iloczyn poprzez metodę reduce: %d%n",
         IntStream.of(values)
                  .reduce((x, y) -> x * y).getAsInt());

      // Suma kwadratów poprzez metody map i sum
      System.out.printf("Suma kwadratów poprzez map i sum: %d%n%n",
         IntStream.of(values)
                  .map(x -> x * x)
                  .sum());        

      // Wyświetlenie elementów po posortowaniu
      System.out.printf("Wartości po posortowaniu: %s%n",
         IntStream.of(values)
                  .sorted()
                  .mapToObj(String::valueOf)
                  .collect(Collectors.joining(" ")));
   }
}

/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
