// Rysunek 9.8. BasePlusCommissionEmployee.java
// Prywatne składowe klasy nadrzędnej nie są dostępne w podklasie.
public class BasePlusCommissionEmployee extends CommissionEmployee {
   private double baseSalary; // Tygodniowe wynagrodzenie bazowe.

   // Konstruktor sześcioargumentowy.
   public BasePlusCommissionEmployee(String firstName, String lastName, 
      String socialSecurityNumber, double grossSales, 
      double commissionRate, double baseSalary) {
      // Jawne wywołanie konstruktora CommissionEmployee.
      super(firstName, lastName, socialSecurityNumber,             
         grossSales, commissionRate);                              

      // Jeśli wynagrodzenie bazowe jest nieprawidłowe, zgłoś wyjątek.
      if (baseSalary < 0.0) {                  
         throw new IllegalArgumentException("Wynagrodzenie bazowe musi być >= 0.0");
      }       

      this.baseSalary = baseSalary;
   }
   
   // Ustaw wynagrodzenie bazowe.
   public void setBaseSalary(double baseSalary) {
      if (baseSalary < 0.0) {                  
         throw new IllegalArgumentException("Wynagrodzenie bazowe musi być >= 0.0");
      }

      this.baseSalary = baseSalary;                
   }

   // Zwróć wynagrodzenie bazowe.
   public double getBaseSalary() {return baseSalary;}

   // Wylicz zarobek.
   @Override
   public double earnings() {
      // Błąd: commissionRate i grossSales są zmiennymi prywatnymi klasy nadrzędnej.
      return baseSalary + (commissionRate * grossSales);                 
   }  

   // Zwróć tekstową reprezentację obiektu BasePlusCommissionEmployee.
   @Override
   public String toString() {
      // Błąd: próba dostępu do zmiennych prywatnych klasy nadrzędnej. 
      return String.format(                                           
         "%s: %s %s%n%s: %s%n%s: %.2f%n%s: %.2f%n%s: %.2f",           
         "pracownik prowizyjny z wynagrodzeniem bazowym", firstName, lastName,
         "numer ubezpieczenia", socialSecurityNumber,
         "łączna sprzedaż", grossSales, "procent prowizji", commissionRate, 
         "wynagrodzenie bazowe", baseSalary);                                
   } 
} 



/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
