// Rysunek 3.8. Account.java
// Klasa Account ze zmienną instancji balance typu double
// i metodą deposit przyjmującą wartość i dokonującą walidacji

public class Account {
   private String name; // Zmienna instancji
   private double balance; // Zmienna instancji

   // Konstruktor Account, który otrzymuje dwa parametry
   public Account(String name, double balance) {
      this.name = name; // Przypisanie parametru name do zmiennej instancji name

      // Sprawdzenie, czy stan konta jest większy od 0.0; jeśli nie,
      // zastosuj wartość początkową równą 0.0
      if (balance > 0.0) { // Jeśli stan konta jest poprawny,
         this.balance = balance; // przypisz go do zmiennej instancji balance
      }
   }

   // Metoda, która deponuje (dodaje) poprawną kwotę do aktualnego salda
   public void deposit(double depositAmount) {      
      if (depositAmount > 0.0) { // Jeśli depositAmount jest poprawne,
         balance = balance + depositAmount; // dodaj go do aktualnego salda
      }
   }

   // Metoda zwraca zawartość balance z obiektu
   public double getBalance() {
      return balance; 
   } 

   // Metoda ustawiająca name w obiekcie
   public void setName(String name) {
      this.name = name; 
   } 

   // Metoda pobierająca name w obiekcie
   public String getName() {
      return name; 
   }
}

/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
