// Rysunek 27.13. Time1Test.java
// Obiekt Time1 użyty w aplikacji
package com.deitel.timetest;

import com.deitel.timelibrary.Time1;

public class Time1Test {
   public static void main(String[] args) {
      // Utworzenie i inicjalizacja obiektu Time1
      Time1 time = new Time1(); // Wywołanie konstruktora Time1

      // Wyświetlenie tekstowych reprezentacji czasu
      displayTime("Po utworzeniu obiektu", time);
      System.out.println(); 

      // Zmień czas i wyświetl wartości ponownie
      time.setTime(13, 27, 6); 
      displayTime("Po wywołaniu setTime", time);
      System.out.println(); 

      // Spróbuj ustawić niepoprawny czas
      try {
         time.setTime(99, 99, 99); // Wszystkie wartości są poza zakresem
      } 
      catch (IllegalArgumentException e) {
         System.out.printf("Wyjątek: %s%n%n", e.getMessage());
      } 

      // Wyświetl czas po próbie użycia wartości spoza dopuszczalnego zakresu
      displayTime("Po wywołaniu setTime z nieprawidłowymi wartościami", time);
   } 

   // Wyświetla obiekt Time1 w formatach 12- i 24- godzinnych
   private static void displayTime(String header, Time1 t) {
      System.out.printf("%s%nFormat uniwersalny: %s%nFormat 12-godzinny: %s%n",
         header, t.toUniversalString(), t.toString());
   } 
}



/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
