// Rysunek 26.7. Server.java
// Część serwerowa bezpołączeniowej komunikacji typu klient – serwer wykorzystującej datagramy
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.awt.BorderLayout;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class Server extends JFrame 
{
   private JTextArea displayArea; // Wyświetla otrzymane pakiety
   private DatagramSocket socket; // Gniazdo zapewniające komunikację z klientem

   // Konfiguracja interfejsu graficznego i DatagramSocket
   public Server()
   {
      super("Serwer");

      displayArea = new JTextArea(); // Utworzenie displayArea
      add(new JScrollPane(displayArea), BorderLayout.CENTER);
      setSize(400, 300); // Ustaw rozmiar okna
      setVisible(true); // Pokaż okno

      try // Utworzenie DatagramSocket w celu wysyłania i otrzymywania pakietów
      {
         socket = new DatagramSocket(5000);
      } 
      catch (SocketException socketException) 
      {
         socketException.printStackTrace();
         System.exit(1);
      } 
   }

   // Oczekiwanie na otrzymanie pakietów; wyświetlenie danych i wysłanie odpowiedzi do klienta
   public void waitForPackets()
   {
      while (true) 
      {
         try // Odbierz pakiet, wyświetl zawartość i zwróć kopię klientowi
         {
            byte[] data = new byte[100]; // Konfiguracja pakietu
            DatagramPacket receivePacket = 
               new DatagramPacket(data, data.length);

            socket.receive(receivePacket); // Czekaj na otrzymanie pakietu

            // Wyświetl informacje z otrzymanego pakietu
            displayMessage("\nOtrzymany pakiet:" + 
               "\nZ hosta: " + receivePacket.getAddress() + 
               "\nPort hosta: " + receivePacket.getPort() + 
               "\nDługość: " + receivePacket.getLength() + 
               "\nZawartość:\n\t" + new String(receivePacket.getData(), 
                  0, receivePacket.getLength()));

            sendPacketToClient(receivePacket); // Wysłanie pakietu do klienta
         } 
         catch (IOException ioException)
         {
            displayMessage(ioException + "\n");
            ioException.printStackTrace();
         } 
      } 
   }

   // Wysłanie kopii pakietu do klienta
   private void sendPacketToClient(DatagramPacket receivePacket) 
      throws IOException
   {
      displayMessage("\n\nWysyłanie kopii danych do klienta...");

      // Utworzenie pakietu do wysłania
      DatagramPacket sendPacket = new DatagramPacket(
         receivePacket.getData(), receivePacket.getLength(), 
         receivePacket.getAddress(), receivePacket.getPort());

      socket.send(sendPacket); // Wysłanie pakietu do klienta
      displayMessage("Pakiet wysłany\n");
   }

   // Modyfikacja displayArea w wątku obsługi zdarzeń
   private void displayMessage(final String messageToDisplay)
   {
      SwingUtilities.invokeLater(
         new Runnable() 
         {
            public void run() // Aktualizuje displayArea
            {
               displayArea.append(messageToDisplay); // Wyświetl komunikat
            } 
         } 
      ); 
   } 
}

/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/