// Rysunek 23.23. FibonacciTask.java
// Podklasa klasy Task, która oblicza w tle liczbę ciągu Fibonacciego
import javafx.concurrent.Task;

public class FibonacciTask extends Task<Long> {
   private final int n; // Liczba ciągu Fibonacciego, którą należy obliczyć 

   // Konstruktor
   public FibonacciTask(int n) {
      this.n = n;
   } 

   // Długo działający kod uruchamiany w wątku roboczym
   @Override
   protected Long call() {
      updateMessage("Obliczam...");
      long result = fibonacci(n);
      updateMessage("Obliczenia zakończono."); 
      return result;
   } 

   // Rekurencyjna metoda fibonacci; oblicza n-tą liczbę ciągu Fibonacciego
   public long fibonacci(long number) {
      if (number == 0 || number == 1) {
         return number;
      }
      else {
         return fibonacci(number - 1) + fibonacci(number - 2);
      }
   }
} 

/*************************************************************************
* (C) Copyright 1992-2015 by Deitel & Associates, Inc. and               *
* Pearson Education, Inc. All Rights Reserved.                           *
*                                                                        *
* DISCLAIMER: The authors and publisher of this book have used their     *
* best efforts in preparing the book. These efforts include the          *
* development, research, and testing of the theories and programs        *
* to determine their effectiveness. The authors and publisher make       *
* no warranty of any kind, expressed or implied, with regard to these    *
* programs or to the documentation contained in these books. The authors *
* and publisher shall not be liable in any event for incidental or       *
* consequential damages in connection with, or arising out of, the       *
* furnishing, performance, or use of these programs.                     *
*************************************************************************/