// BallAnimationTimerController.java
// Odbijanie koła od krawędzi okna za pomocą animacji będącej podklasą klasy AnimationTimer
import java.security.SecureRandom;
import javafx.animation.AnimationTimer;
import javafx.fxml.FXML;
import javafx.geometry.Bounds;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Circle;
import javafx.util.Duration;

public class BallAnimationTimerController {
   @FXML private Circle c;
   @FXML private Pane pane;
   
   public void initialize() {
      SecureRandom random = new SecureRandom();
           
      // Definicja animacji.
      AnimationTimer timer = new AnimationTimer() {
         int dx = 1 + random.nextInt(5);
         int dy = 1 + random.nextInt(5);
         int velocity = 60; // Używane do skalowania ruchu
         long previousTime = System.nanoTime(); // Czas od uruchomienia aplikacji

         // Określenie ruchu obiektu Circle dla aktualnej klatki animacji
         @Override
         public void handle(long now) {
            double elapsedTime = (now - previousTime) / 1000000000.0;
            previousTime = now;
            double scale = elapsedTime * velocity;

            Bounds bounds = pane.getBoundsInLocal();
            c.setLayoutX(c.getLayoutX() + dx * scale);
            c.setLayoutY(c.getLayoutY() + dy * scale);

            if (hitRightOrLeftEdge(bounds)) {
               dx *= -1;
            }

            if (hitTopOrBottom(bounds)) {
               dy *= -1;
            }
         }
      };
         
      timer.start();
   }
   
   // Określ, czy koło uderzyło w lewą lub prawą krawędź okna
   private boolean hitRightOrLeftEdge(Bounds bounds) {
      return (c.getLayoutX() <= (bounds.getMinX() + c.getRadius())) ||
         (c.getLayoutX() >= (bounds.getMaxX() - c.getRadius()));
   }

   // Określ, czy koło uderzyło w górną lub dolną krawędź okna
   private boolean hitTopOrBottom(Bounds bounds) {
      return (c.getLayoutY() <= (bounds.getMinY() + c.getRadius())) ||
         (c.getLayoutY() >= (bounds.getMaxY() - c.getRadius()));
   }
}



/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
