// Rysunek 6.9. Scope.java
// Klasa Scope ilustrująca zasięg pól i zmiennych lokalnych

public class Scope {
   // Pole dostępne dla wszystkich metod klasy
   private static int x = 1;                               

   // Metoda main tworzy i inicjalizuje zmienną lokalną x
   // i wywołuje metody useLocalVariable i useField
   public static void main(String[] args) {
      int x = 5; // Lokalna zmienna x metody przesłania pole x

      System.out.printf("Lokalne x w main wynosi %d%n", x);

      useLocalVariable(); // Metoda useLocalVariable ma lokalne x
      useField(); // Metoda useField używa pola x klasy Scope
      useLocalVariable(); // Metoda useLocalVariable ponownie inicjalizuje zmienną lokalną x
      useField(); // Pole x klasy Scope zachowuje swoją wartość

      System.out.printf("%nLokalne x w main wynosi %d%n", x);
   } 

   // Tworzy i inicjalizuje zmienną lokalną x w każdym wywołaniu
   public static void useLocalVariable() {
      int x = 25; // Inicjalizowane przy każdym wywołaniu useLocalVariable

      System.out.printf(
         "%nLokalne x przy wejściu do metody useLocalVariable wynosi %d%n", x);
      ++x; // Modyfikuje lokalną zmienną x metody
      System.out.printf(
         "Lokalne x przed wyjściem z metody useLocalVariable wynosi %d%n", x);
   } 

   // Modyfikuje pole x klasy Scope w każdym wywołaniu
   public static void useField() {
      System.out.printf(
         "%nPole x przy wejściu do metody useField wynosi %d%n", x);
      x *= 10; // Modyfikuje pole x klasy Scope
      System.out.printf(
         "Pole x przed wyjściem z metody useField wynosi %d%n", x);
   }
} 


/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
