/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.property.editor;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.dialog.FontSelectorDialog;
import org.controlsfx.property.editor.AbstractObjectField;
import org.controlsfx.property.editor.AbstractPropertyEditor;
import org.controlsfx.property.editor.NumericField;
import org.controlsfx.property.editor.PropertyEditor;

public class Editors {
    private Editors() {
    }

    public static final PropertyEditor<?> createTextEditor(PropertySheet.Item property) {
        return new AbstractPropertyEditor<String, TextField>(property, new TextField()){
            {
                Editors.enableAutoSelectAll((TextInputControl)this.getEditor());
            }

            protected StringProperty getObservableValue() {
                return ((TextField)this.getEditor()).textProperty();
            }

            @Override
            public void setValue(String value) {
                ((TextField)this.getEditor()).setText(value);
            }
        };
    }

    public static final PropertyEditor<?> createNumericEditor(final PropertySheet.Item property) {
        return new AbstractPropertyEditor<Number, NumericField>(property, new NumericField(property.getType())){
            private Class<? extends Number> sourceClass;
            {
                super(property2, control);
                this.sourceClass = property.getType();
                Editors.enableAutoSelectAll((TextInputControl)this.getEditor());
            }

            @Override
            protected ObservableValue<Number> getObservableValue() {
                return ((NumericField)((Object)this.getEditor())).valueProperty();
            }

            @Override
            public Number getValue() {
                try {
                    return this.sourceClass.getConstructor(String.class).newInstance(((NumericField)((Object)this.getEditor())).getText());
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    e.printStackTrace();
                    return null;
                }
            }

            @Override
            public void setValue(Number value) {
                this.sourceClass = value.getClass();
                ((NumericField)((Object)this.getEditor())).setText(value.toString());
            }
        };
    }

    public static final PropertyEditor<?> createCheckEditor(PropertySheet.Item property) {
        return new AbstractPropertyEditor<Boolean, CheckBox>(property, new CheckBox()){

            protected BooleanProperty getObservableValue() {
                return ((CheckBox)this.getEditor()).selectedProperty();
            }

            @Override
            public void setValue(Boolean value) {
                ((CheckBox)this.getEditor()).setSelected(value.booleanValue());
            }
        };
    }

    public static final <T> PropertyEditor<?> createChoiceEditor(PropertySheet.Item property, final Collection<T> choices) {
        return new AbstractPropertyEditor<T, ComboBox<T>>(property, new ComboBox()){
            {
                super(property, control);
                ((ComboBox)this.getEditor()).setItems(FXCollections.observableArrayList((Collection)choices));
            }

            @Override
            protected ObservableValue<T> getObservableValue() {
                return ((ComboBox)this.getEditor()).getSelectionModel().selectedItemProperty();
            }

            @Override
            public void setValue(T value) {
                ((ComboBox)this.getEditor()).getSelectionModel().select(value);
            }
        };
    }

    public static final PropertyEditor<?> createColorEditor(PropertySheet.Item property) {
        return new AbstractPropertyEditor<Color, ColorPicker>(property, new ColorPicker()){

            @Override
            protected ObservableValue<Color> getObservableValue() {
                return ((ColorPicker)this.getEditor()).valueProperty();
            }

            @Override
            public void setValue(Color value) {
                ((ColorPicker)this.getEditor()).setValue((Object)value);
            }
        };
    }

    public static final PropertyEditor<?> createDateEditor(PropertySheet.Item property) {
        return new AbstractPropertyEditor<LocalDate, DatePicker>(property, new DatePicker()){

            @Override
            protected ObservableValue<LocalDate> getObservableValue() {
                return ((DatePicker)this.getEditor()).valueProperty();
            }

            @Override
            public void setValue(LocalDate value) {
                ((DatePicker)this.getEditor()).setValue((Object)value);
            }
        };
    }

    public static final PropertyEditor<?> createFontEditor(PropertySheet.Item property) {
        return new AbstractPropertyEditor<Font, AbstractObjectField<Font>>(property, (AbstractObjectField)new AbstractObjectField<Font>(){

            @Override
            protected Class<Font> getType() {
                return Font.class;
            }

            @Override
            protected String objectToString(Font font) {
                return font == null ? "" : String.format("%s, %.1f", font.getName(), font.getSize());
            }

            @Override
            protected Font edit(Font font) {
                FontSelectorDialog dlg = new FontSelectorDialog(font);
                Optional optionalFont = dlg.showAndWait();
                return (Font)optionalFont.get();
            }
        }){

            @Override
            protected ObservableValue<Font> getObservableValue() {
                return ((AbstractObjectField)((Object)this.getEditor())).getObjectProperty();
            }

            @Override
            public void setValue(Font value) {
                ((AbstractObjectField)((Object)this.getEditor())).getObjectProperty().set((Object)value);
            }
        };
    }

    public static final Optional<PropertyEditor<?>> createCustomEditor(PropertySheet.Item property) {
        return property.getPropertyEditorClass().map(cls -> {
            try {
                Constructor cn = cls.getConstructor(PropertySheet.Item.class);
                if (cn != null) {
                    return (PropertyEditor)cn.newInstance(property);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                ex.printStackTrace();
            }
            return null;
        });
    }

    private static void enableAutoSelectAll(TextInputControl control) {
        control.focusedProperty().addListener((o, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                Platform.runLater(() -> control.selectAll());
            }
        });
    }
}

