/******************************************************************************
 *  Kompilacja:  javac Insertion.java
 *  Wykonanie:    java Insertion < input.txt
 *  Pliki z danymi:   http://www.cs.princeton.edu/introcs/43sort/8words.txt
 *                http://www.cs.princeton.edu/introcs/43sort/TomSawyer.txt
 *  
 *  Wczytuje ciągi znaków ze standardowego wejścia i wyświetla je posortowane.
 *  Używa sortowania przez wstawianie.
 *
 *  % java Insertion < 8words.txt
 *  and but had him his the was you 
 *
 ******************************************************************************/

public class Insertion {

    public static void sort(Comparable[] a) {
        int n = a.length;
        for (int i = 1; i < n; i++) {
            for (int j = i; j > 0; j--) {
                if (a[j-1].compareTo(a[j]) > 0) {
                    exch(a, j-1, j);
                }
                else break;
            }
        }
    }

    // przestawia a[i] z a[j]
    private static void exch(Comparable[] a, int i, int j) {
        Comparable swap = a[i];
        a[i] = a[j];
        a[j] = swap;
    }

    // wczytuje sekwencję słów ze standardowego wejścia i wyświetla
    // je po posortowaniu
    public static void main(String[] args) {
        String[] a = StdIn.readAllStrings();
        sort(a);
        for (int i = 0; i < a.length; i++) {
            StdOut.print(a[i] + " ");
        }
        StdOut.println();
    }
}

