/******************************************************************************
 *  Kompilacja:  javac FrequencyCount.java
 *  Wykonanie:    java FrequencyCount < file.txt
 *  Zależności: StdIn.java Counter.java
 *  Pliki z danymi:   http://www.cs.princeton.edu/introcs/43sort/mobydicks.txt
 *                http://www.cs.princeton.edu/introcs/43sort/Leipzig1M.txt
 *                http://www.cs.princeton.edu/introcs/43sort/Leipzig100K.txt
 *                http://www.cs.princeton.edu/introcs/43sort/Leipzig200KM.txt
 *
 *  Wczytywanie sekwencji słów rozdzielonych spacjami.
 *  Zliczanie wystąpień każdego słowa i wyświetlanie wyrazów
 *  posortowanych według liczby pojawień się.
 *
 *  % java FrequencyCount < mobydick.txt
 *  the: 13527
 *  of: 6374
 *  and: 5857
 *  a: 4457
 *  to: 4388
 *  in: 3773
 *  that: 2666
 *  his: 2404
 *  I: 1742
 *  with: 1615
 *  ...
 *
 ******************************************************************************/

public class FrequencyCount {

    public static void main(String[] args) {

        // Wczytywanie słów jako tablicy
        String s = StdIn.readAll();
        String[] words = s.split("\\s+");

        // Sortowanie słów
        Merge.sort(words);

		// zapisywanie liczby wystąpień wszystkich słów
        Counter[] zipf = new Counter[words.length];
        int m = 0;                                        // Liczba różnych słów
        for (int i = 0; i < words.length; i++) {
            if (i == 0 || !words[i].equals(words[i-1]))   // instrukcja OR przyspiesza przetwarzanie
                zipf[m++] = new Counter(words[i], words.length);
            zipf[m-1].increment();
        }

        // Sortowanie według liczby wystąpień i wyświetlanie
        Merge.sort(zipf, 0, m);                           // Sortowanie podtablicy
        for (int j = m-1; j >= 0; j--) {
            StdOut.println(zipf[j]);
        }
    }
}