/******************************************************************************
 *  Kompilacja:  javac MM1Queue.java
 *  Wykonanie:    java MM1Queue lambda mu
 *  Zależności: Queue.java Histogram.java
 *
 *  Symuluje kolejkę M/M/1, gdzie zgłoszenia i obsługa to procesy
 *  Poissona z częstotliwością zgłoszeń lambda i częstotliwością obsługi mu.
 *
 *  % java MM1Queue .20 .33
 *
 *  % java MM1Queue .20 .25 
 *
 *  % java MM1Queue .20 .21
 *
 *
 *  Uwagi
 *  -------
 *   - Zakładamy, że czasy zgłoszeń i obsługi są niezależne od siebie.
 * 
 *
 ******************************************************************************/

public class MM1Queue { 

    public static void main(String[] args) { 
        double lambda = Double.parseDouble(args[0]);  // częstotliwość zgłoszeń
        double mu     = Double.parseDouble(args[1]);  // częstotliwość obsługi

        Queue<Double> queue  = new Queue<Double>();       // czasy zgłoszeń klientów
        double nextArrival   = StdRandom.exp(lambda);     // czas następnego zgłoszenia
        double nextDeparture = Double.POSITIVE_INFINITY;  // czas następnej obsługi

        // double expectedWait = 1.0 / (mu - lambda);        // W = oczekiwany czas w systemie

        double totalWait = 0.0;
        long customersServiced = 0;

        // obiekt histogramu
        Histogram hist = new Histogram(60 + 1);

        StdDraw.setCanvasSize(1000, 600);
        StdDraw.enableDoubleBuffering();

        // symulacja kolejki M/M/1
        while (true) {

            // zgłoszenie
            if (nextArrival <= nextDeparture) {
                if (queue.isEmpty()) nextDeparture = nextArrival + StdRandom.exp(mu);
                queue.enqueue(nextArrival);
                nextArrival += StdRandom.exp(lambda);
            }

            // obsługa
            else {
                double wait = nextDeparture - queue.dequeue();
                hist.addDataPoint(Math.min(60,  (int) (Math.round(wait))));
                totalWait += wait;
                customersServiced++;
                StdDraw.clear();
                hist.draw();
                StdDraw.show();
                StdDraw.pause(30);
                if (queue.isEmpty()) nextDeparture = Double.POSITIVE_INFINITY;
                else                 nextDeparture += StdRandom.exp(mu);
                
            }
        }

    }

}
