/******************************************************************************
 *  Kompilacja:  javac IndexGraph.java
 *  Zależności: Graph.java In.java
 *  Wykonanie:    java IndexGraph movies.txt "/"
 *  Pliki z danymi:   https://introcs.cs.princeton.edu/45graph/tinyGraph.txt
 *                https://introcs.cs.princeton.edu/45graph/movies.txt
 *                https://introcs.cs.princeton.edu/45graph/amino.csv
 *  
 *  Tworzy graf, a następnie przyjmuje nazwy wierzchołków ze standardowego wejścia i
 *  wyświetla sąsiadów tych wierzchołków.
 *
 *  % java IndexGraph tinyGraph.txt " "
 *  C
 *    A
 *    B
 *    G
 *  A
 *    B
 *    C
 *    G
 *    H
 *
 ******************************************************************************/

public class IndexGraph {

    public static void main(String[] args) {

        // wczytuje graf z pliku
        String filename = args[0];
        String delimiter = args[1];
        Graph G = new Graph(filename, delimiter);

        // wczytuje wierzchołek i wyświetla jego sąsiadów
        while (!StdIn.isEmpty()) {
            String v = StdIn.readLine();
            if (G.hasVertex(v)) {
                for (String w : G.adjacentTo(v)) {
                    StdOut.println("  " + w);
                }
            }
        }
    }

}