/******************************************************************************
 *  Kompilacja:  javac Questions.java
 *  Wykonanie:    java Questions k
 *  Zależności  StdIn.java
 *
 *  Ten kod wykorzystuje wyszukiwanie binarne do gry w dwadzieścia pytań.
 *  Przyjmuje z wiersza poleceń argument w postaci liczby całkowitej k, wyświetla prośbę o pomyślenie
 *  liczby z przedziału od 0 do n-1, gdzie n = 2^k, i zawsze zgaduje odpowiedź
 *  w n pytaniach.
 *
 *  %  java Questions 7
 *  Pomyśl o liczbie całkowitej z przedziału od 0 do 127
 *  Czy jest mniejsza niż 64?  false
 *  Czy jest mniejsza niż 96?  true
 *  Czy jest mniejsza niż 80?  true
 *  Czy jest mniejsza niż 72?  false
 *  Czy jest mniejsza niż 76?  false
 *  Czy jest mniejsza niż 78?  true
 *  Czy jest mniejsza niż 77?  false
 *  Pomyślałeś o liczbie 77
 *
 ******************************************************************************/

public class Questions {

    // Niezmiennik: poprawna odpowiedź należy do przedziału [lo, hi)
    public static int search(int lo, int hi) {
        if ((hi - lo) == 1) return lo;
        int mid = lo + (hi - lo) / 2;
        StdOut.printf("Czy jest mniejsza niż %d?  ", mid);
        if (StdIn.readBoolean()) return search(lo, mid);
        else                     return search(mid, hi);
    }

    public static void main(String[] args) {
        int k = Integer.parseInt(args[0]);
        int n = (int) Math.pow(2, k);
        StdOut.printf("Pomyśl o liczbie całkowitej z przedziału od %d do %d\n", 0, n-1);
        int secret = search(0, n);
        StdOut.printf("Pomyślałeś o liczbie %d\n", secret);
    }

}