/******************************************************************************
 *  Kompilacja:  javac ArrayStackOfStrings.java
 *  Wykonanie:    java ArrayStackOfStrings
 *  Pliki z danymi:   https://introcs.cs.princeton.edu/43stack/tobe.txt
 *  
 *  Implementacja stosu ciągów znaków z użyciem tablicy o stałej długości.
 *
 *  % more tobe.txt 
 *  to be or not to - be - - that - - - is 
 * 
 *  % java ArrayStackOfStrings 5 < tobe.txt 
 *  to be not that or be
 *
 ******************************************************************************/

import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayStackOfStrings implements Iterable<String> {
    private String[] items;  // przechowuje elementy
    private int n;           // liczba elementów na stosie

    public ArrayStackOfStrings(int capacity) {
        items = new String[capacity];
    }

    public boolean isEmpty() {
        return n == 0; 
    }

    public boolean isFull() {
        return n == items.length; 
    }

    public void push(String item) {
        items[n++] = item;
    }

    public String pop() {
        return items[--n];
    }

    public Iterator<String> iterator() {
        return new ReverseArrayIterator();
    }

    // Iterator. Metoda remove() nie jest zaimplementowana, ponieważ jest opcjonalna
    private class ReverseArrayIterator implements Iterator<String> {
        private int i = n-1;
        public boolean hasNext()  { return i >= 0;                              }
        public void remove()      { throw new UnsupportedOperationException();  }

        public String next() {
            if (!hasNext()) throw new NoSuchElementException();
            return items[i--];
        }
    }


    public static void main(String[] args) {
        int capacity = Integer.parseInt(args[0]);
        ArrayStackOfStrings stack = new ArrayStackOfStrings(capacity);
        while (!StdIn.isEmpty()) {
            String item = StdIn.readString();
            if (!item.equals("-")) {
                stack.push(item); 
            }
            else {
                StdOut.print(stack.pop() + " ");
            }
        }
        StdOut.println();
    } 
} 