/**
 * Obiekty i funkcje pomocnicze z rozdziału 4.
 * Autor: Luis Atencio
 */
const R = require('ramda');

// checkType :: Type -> Type -> Type | TypeError
const checkType = R.curry(function(typeDef, obj) {
	if(!R.is(typeDef, obj)) {
		let type = typeof obj;
		throw new TypeError(`Type mismatch. Expected [${typeDef}] but found [${type}]`);
	}
	return obj;
});

// Funkcje pomocnicze
module.exports = {
	checkType: checkType	
};

const Tuple = function( /* Typy */ ) {
	const typeInfo = Array.prototype.slice.call(arguments, 0);
	const _T = function( /* Wartości */ ) {
		const values = Array.prototype.slice.call(arguments, 0);
		if(values.some(val => val === null || val === undefined)) {
			throw new ReferenceError('Krotki nie mogą zawierać wartości null');
		}
		if(values.length !== typeInfo.length) {
			throw new TypeError('Arność krotki nie pasuje do prototypu');
		}	
		values.map((val, index) => {			
			this['_' + (index + 1)] = checkType(typeInfo[index],val);			
		}, this);		
		Object.freeze(this);
	};
	_T.prototype.values = function () {				
		return Object.keys(this).map(k => this[k], this);
	};	
	return _T;
};

// Eksportowanie klasy Tuple 
module.exports.Tuple = Tuple;