
const DB_NAME = 'students';

var openDB = function() {
    const version = 2;
    return new Promise(function(resolve, reject) {
        //Otwieranie bazy danych
        var request = indexedDB.open("studentData", version);
        var db;

        //Obsługa zdarzenia onupgradeneeded.
		//Uruchamiana, gdy baza jest nowa lub po modyfikacji wersji.
        request.onupgradeneeded = function(e) {
            db = e.target.result;
            e.target.transaction.onerror = indexedDB.onerror;

            //Usuwanie bazy, jeśli już istnieje
            if(db.objectStoreNames.contains(DB_NAME)) {
                db.deleteObjectStore(DB_NAME);
            }
            //Tworzenie nowej bazy o określonej właściwości keyPath
            var store = db.createObjectStore("students", {keyPath: "ssn", autoIncrement: true});
        };

        //Uruchamiane po udanym otwarciu bazy
        request.onsuccess = function(e) {
            db = e.target.result;
            resolve(db);
        };

        //Uruchamiane po nieudanej próbie otwarcia bazy
        request.onerror = function(e) {
            reject(Error("Nie można otworzyć bazy"));
        };
    });
};

var find = function (db, studentId) {
    const trans = db.transaction(['students'], 'readonly');
    const store = trans.objectStore('students');
    return new Promise(function(resolve, reject) {
        var request = store.get(studentId);

        request.onerror = function() {
            reject(new Error('Studenta nie znaleziono!'));
        };
        request.onsuccess = function() {
            resolve(request.result);
        };
    });
};

var getAllStudents = function(db) {
    var studentArr = [];

    //Tworzenie obiektu transakcji na potrzeby operacji w/w
    var trans = db.transaction([DB_NAME], "readwrite");

    //Pobieranie referencji do bazy
    var store = trans.objectStore(DB_NAME);

    //Opakowywanie całej logiki w obietnicę
    return new Promise(function(resolve, reject) {
        //Otwieranie kursora w celu pobrania elementów z bazy
        //var keyRange = IDBKeyRange.lowerBound(0);
        var cursorRequest = store.openCursor();

        //Wywołanie zwrotne dla powodzenia
        cursorRequest.onsuccess = function(e) {
            var result = e.target.result;

            //Przetwarzanie obietnicy, gdy zmienna result jest pusta
            if(result === null || result === undefined) {

                resolve({
                    'db': db,
                    'data': studentArr
                });
            }
            //Umieszczanie wyniku na liście
            else{
                studentArr.push(result.value);
                result.continue();
            }
        };

        //Wywołanie zwrotne dla błędu
        cursorRequest.onerror = function(e){
            reject("Nie można pobrać danych z bazy");
        };
    });
};

var addStudent = function(db, firstname, lastname, ssn) {
    //Tworzenie obiektu transakcji na potrzeby operacji w/w
    var trans = db.transaction([DB_NAME], "readwrite");
    var store = trans.objectStore(DB_NAME);

    //Umieszczanie logiki w obietnicy
    return new Promise(function(resolve, reject){
        //Przesyłanie żądania w celu dodania elementu
        var request = store.add({
            ssn: ssn, firstname: firstname, lastname: lastname
        });

        //Wywołanie zwrotne dla powodzenia
        request.onsuccess = function(e) {
            resolve(db);
        };

        //Wywołanie zwrotne dla błędu
        request.onerror = function(e) {
            console.log(e.value);
            reject("Nie można dodać przekazanego elementu");
        };
    });
};


var addStudents = function(db, arr) {
    //Tworzenie obiektu transakcji na potrzeby operacji w/w
    var trans = db.transaction([DB_NAME], "readwrite");
    var store = trans.objectStore(DB_NAME);

    //Opakowywanie logiki w obietnicę
    return new Promise(function(resolve, reject){
        for(let i in arr) {
            //Przesyłanie żądania dodania elementu
            var request = store.add(arr[i]);

            //Wywołanie zwrotne dla powodzenia
            request.onsuccess = function(e) {
                console.log('Dodano studenta: ' + arr[i].ssn);
            };

            //Wywołanie zwrotne dla błędu
            request.onerror = function(e) {
                console.log(e.value);
                reject("Nie można dodać przekazanego elementu");
            };
        }
        resolve(db);
    });
};

var deleteStudent = function(db, id) {
    return new Promise(function(resolve, reject){
        var trans = db.transaction([DB_NAME], "readwrite");
        var store = trans.objectStore(DB_NAME);
        var request = store.delete(id);

        request.onsuccess = function(e) {
            resolve(true);
        };

        request.onerror = function(e) {
            console.log(e);
            reject("Nie można usunąć elementu");
        };
    });
};