﻿std::string QuarterlyReportGenerator::generate()
{
    std::vector<Result> results = database.queryResults(
                                             beginDate, endDate);
    std::string pageText;

    pageText += "<html><head><title>"
            "Raport kwartalny"
            "</title></head><body><table>";
    if (results.size() != 0) {
        for (std::vector<Result>::iterator it = results.begin();
                it != results.end();
                ++it) {
            pageText += "<tr>";
            pageText += "<td>" + it->wydział + "</td>";
            pageText += "<td>" + it->kierownik + "</td>";
            char buffer [128];
            sprintf(buffer, "<td>$%d</td>", it->netProfit / 100);
            pageText += std::string(buffer);
            sprintf(buffer, "<td>$%d</td>", it->operatingExpense / 100);
            pageText += std::string(buffer);
             pageText += "</tr>";
         }
    } else {
        pageText += "Brak wynikow dla wskazanego okresu ";
    }
    pageText += "</table>";
    pageText += "</body>";
    pageText += "</html>";

    return pageText;
}
