<?php
require_once "OAuth.php";       // biblioteka OAuth
require_once "common.php";      // wspólne funkcje i zmienne

// odczytuje z pliku cookie parametry tokenu żądania i wyodrębnia poszczególne wartości
$request_cookie = $_COOKIE["requestToken"];
parse_str($request_cookie);

// tworzy wymagane zmienne konsumenta
$test_consumer = new OAuthConsumer($key, $secret, NULL);
$req_token = new OAuthConsumer($token, $token_secret, NULL);
$sig_method = new OAuthSignatureMethod_HMAC_SHA1();

// wymienia uwierzytelniony token żądania na token dostępu
$params = array('oauth_verifier' => $_GET['oauth_verifier']);
$acc_req = OAuthRequest::from_consumer_and_token($test_consumer, $req_token, "GET", $oauth_access_token_endpoint, $params);
$acc_req->sign_request($sig_method, $test_consumer, $req_token);
$access_ret = run_curl($acc_req->to_url(), 'GET');

// jeśli udało się pobrać token dostępu, poniższy kod powinien wyodrębnić wartości oauth_token i
// oauth_token_secret oraz wygenerować na ich podstawie obiekt konsumenta dostępu
$access_token = array();
parse_str($access_ret, $access_token);
$access_consumer = new OAuthConsumer($access_token['oauth_token'], $access_token['oauth_token_secret'], NULL);

// przygotowuje zawartość żądania aktualizacji PUT
$guid = $access_token['xoauth_yahoo_guid'];
$title = 'Nowa aktualizacja';// dowolny tytuł
$description = 'Jest teraz godzina '.date("g:i a");// dowolny opis
$link = 'http://en.wikipedia.org/wiki/Haiku#Examples';// dowolny link
$source = 'APP.'.$appid;// uwaga: składnia 'APP.'
$date = time();
$suid = 'uniquestring'.time();// dowolny, unikatowy łańcuch
$body = array(
	"updates" => array(
		array(
			"collectionID" => $guid,
			"collectionType" => "guid",
			"class" => "app",
			"source" => $source,
			"type" => 'appActivity',
			"suid" => $suid,
			"title" => $title,
			"description" => $description,
			"link" => $link,
			"pubDate" => (string)$date
		)
	)
);

// generuje adres URL dla żądania aktualizacji PUT
$url = sprintf("http://%s/v1/user/%s/updates/%s/%s",
	'social.yahooapis.com', 
	$guid, 
	$source, 
	urlencode($suid)
);

// generuje i podpisuje żądanie
$request = OAuthRequest::from_consumer_and_token($test_consumer, 
	$access_consumer, 
	'PUT',
	$url, 
	array());
$request->sign_request(new OAuthSignatureMethod_HMAC_SHA1(),
	$test_consumer, 
	$access_consumer
);

// definiuje nagłówki żądania
$headers = array("Accept: application/json");
$headers[] = $request->to_header();
$headers[] = "Content-type: application/json";

// koduje zawartość żądania w formacie JSON i wysyła żądanie PUT
$content = json_encode($body);
$resp = run_curl($url, 'PUT', $headers, $content);

// w trybie diagnostycznym wyświetla podpisy i nagłówki
if ($debug){
    $debug_out = array('Access token' => $access_token,
                       'PUT URL'      => $url,
                       'PUT headers'  => $headers,
                       'PUT content'  => $content,
                       'PUT response' => $resp);
    
    print_r($debug_out);
}
?>
