<?php
require_once "Auth/OpenID/Consumer.php";    // kod konsumenta openid
require_once "Auth/OpenID/FileStore.php";   // pamięć plikowa
require_once "Auth/OpenID/AX.php";          // rozszerzenie attribute exchange
require_once "OAuth.php";                   // biblioteka oauth

define('APP_ROOT', 'http://www.jcleblanc.com/projects/openid-oauth-php/');
define('FILE_COMPLETE', 'complete.php');
define('STORAGE_PATH', 'php_consumer');

define('CONSUMER_KEY', 'dj0yJmk9ZTFpdkpzaHdmcnBxJmQ9WVdrOWRtOUpNM05uTnpnbWNHbzlNemc1TnpFMk56WXkmcz1jb25zdW1lcnNlY3JldCZ4PWIz');
define('CONSUMER_SECRET', '63828cbe4f2ffcf419e5d7f663b0f606339c8798');
define('APP_ID', 'voI3sg78');

$debug = true;
$base_url = "http://www.jcleblanc.com/projects/openid-oauth-php/complete.php";
$request_token_endpoint = 'https://api.login.yahoo.com/oauth/v2/get_request_token';
$authorize_endpoint = 'https://api.login.yahoo.com/oauth/v2/request_auth';
$oauth_access_token_endpoint = 'https://api.login.yahoo.com/oauth/v2/get_token';

/***************************************************************************
 * Function: Uruchamia CURL
 * Description: Wysyła żądanie CURL
 * Parameters: url (string) - Adres URL, na który zostanie wysłane żądanie
 *             method (string) - Metoda transferu żądania HTTP
 *             headers - Nagłówki protokołu HTTP
 *             postvals - Wartości żądania POST
 **************************************************************************/
function run_curl($url, $method = 'GET', $headers = null, $postvals = null){
    $ch = curl_init($url);
    
    if ($method == 'GET'){
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    } else {
        $options = array(
            CURLOPT_HEADER => true,
            CURLINFO_HEADER_OUT => true,
            CURLOPT_VERBOSE => true,
            CURLOPT_HTTPHEADER => $headers,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POSTFIELDS => $postvals,
            CURLOPT_CUSTOMREQUEST => $method,
            CURLOPT_TIMEOUT => 3
        );
        curl_setopt_array($ch, $options);
    }
    
    $response = curl_exec($ch);
    curl_close($ch);
    
    return $response;
}

/******************************************************************
 * Function: Uzyskuje obiekt konsumenta
 * Description: Tworzy pamięć plikową konsumenta i obiekt konsumenta OpenID
 ******************************************************************/
function get_consumer() {
    // sprawdza, czy można utworzyć katalog pamięci plikowej
    if (!file_exists(STORAGE_PATH) && !mkdir(STORAGE_PATH)){
        print "Nie można utworzyć katalogu pamięci plikowej '". STORAGE_PATH ."'. Proszę sprawdzić uprawnienia.";
        exit(0);
    }

    // tworzy pamięć plikową konsumenta
    $store = new Auth_OpenID_FileStore(STORAGE_PATH);
    
    // tworzy i zwraca obiekt konsumenta
    $consumer =& new Auth_OpenID_Consumer($store);
    return $consumer;
}
?>
