import sys
import cgi
import openid
import os

from openid.consumer import consumer
from openid.extensions import pape, sreg, ax

'''
' Function: Main
' Description: Rozpoczyna proces uwierzytelniania OpenID
'''
def main():
    # Pobiera parametry zapytania
    params = cgi.FieldStorage()
    
    # Sprawdza, czy przekazano adres URL OpenID
    if not params.has_key('openid_url'):
        print_msg('Proszę podać identyfikator OpenID do sprawdzenia.', 'text/plain')
    else:
        # Pobiera adres URL OpenID
        openid_url = params['openid_url'].value
        
        # Tworzy bazowy obiekt konsumenta
        oidconsumer = consumer.Consumer({}, None)
        
        try:
            request = oidconsumer.begin(openid_url)
        except:
            print_msg('Błąd podczas odkrywania: ' + openid_url, 'text/plain')
        else:
            if request is None:
                print_msg('Nie znaleziono żadnych usług OpenID', 'text/plain')
            else:
                # Buduje zaufany katalog główny i zwrotny adres URL
                trust_root = 'http://%s/' % (os.environ['HTTP_HOST'])
                return_to = 'http://%s/complete.py' % (os.environ['HTTP_HOST'])
                
                # Żądanie rozszerzenia Simple Registration
                sreg_request = sreg.SRegRequest(required=['nickname'], optional=['fullname', 'email'])
                request.addExtension(sreg_request)
                
                # Żądanie rozszerzenia Attribute Exchange
                ax_request = ax.FetchRequest()
                ax_request.add(ax.AttrInfo('http://axschema.org/contact/email', required=False, alias='email'))
                ax_request.add(ax.AttrInfo('http://axschema.org/namePerson', required=False, alias='fullname'))
                ax_request.add(ax.AttrInfo('http://axschema.org/person/gender', required=False, alias='gender'))
                ax_request.add(ax.AttrInfo('http://axschema.org/media/image/default', required=False, alias='picture'))
                request.addExtension(ax_request)
                
                # Żądanie rozszerzenia strategii PAPE
                if params.has_key('policy_phishing'):
                    pape_request = pape.Request([pape.AUTH_PHISHING_RESISTANT])
                    request.addExtension(pape_request)
                
                # openid v1 - wysyła poprzez przekierowanie
                if request.shouldSendRedirect():
                    redirect_url = request.redirectURL(
                        trust_root, return_to, immediate='immediate')
                    print "Location: " + redirect_url
                # openid v2 - używa formularza JavaScriptu do wysłania żądania POST
                else:
                    form_html = request.htmlMarkup(
                        trust_root, return_to,
                        form_tag_attrs={'id':'openid_message'})

                    print_msg(form_html, 'text/html')

'''
' Function: Wyświetla komunikat
' Description: Wyświetla komunikat z przekazanym typem treści
' Inputs: msg (string) - Komunikat do wyświetlenia
'         type (string) - Typ treści (np. text/plain)
'''
def print_msg(msg, type):
    if msg is not None:
        print 'Content-Type: %s' % (type)
        print ''
        print msg

# Ładuje funkcję main()
if __name__ == '__main__':
    main()
    