<?php
error_reporting(E_ERROR);
require_once("includes.php");

$consumer = get_consumer();

// kończy proces uwierzytelniania openid przy użyciu katalogu głównego bieżącej aplikacji
$return_url = sprintf("http://%s%s/complete.php", $_SERVER['SERVER_NAME'], dirname($_SERVER['PHP_SELF']));
$response = $consumer->complete($return_url);

// stan odpowiedzi - uwierzytelnianie zostało anulowane
if ($response->status == Auth_OpenID_CANCEL) {
    $response_state = 'Uwierzytelnianie OpenID zostało anulowane';
// stan odpowiedzi - uwierzytelnianie zakończyło się niepowodzeniem
} else if ($response->status == Auth_OpenID_FAILURE) {
    $response_state = "Uwierzytelnianie OpenID zakończyło się niepowodzeniem: " . $response->message;
// stan odpowiedzi - uwierzytelnianie zakończyło się pomyślnie
} else if ($response->status == Auth_OpenID_SUCCESS) {
    // uzyskuje adres URL tożsamości i wyświetla komunikat o sukcesie
    $openid = htmlentities($response->getDisplayIdentifier());
    $response_state = sprintf('Uwierzytelnianie OpenID przebiegło pomyślnie: <a href="%s">%s</a>', $openid, $openid);

    echo "<h1>ODPOWIEDŹ</h1>";
    var_dump($response);
    echo "<br /><br />";

    if ($response->endpoint->canonicalID){
        $response_state .= '<br />Dołączony XRI CanonicalID: ' . htmlentities($response->endpoint->canonicalID);
    }

    // wyświetla ew. dane zwrócone przez rozszerzenie SReg
    $response_sreg = Auth_OpenID_SRegResponse::fromSuccessResponse($response)->contents();
    echo "<h1>SReg</h1>";
    var_dump(Auth_OpenID_SRegResponse::fromSuccessResponse($response));
    foreach ($response_sreg as $item => $value){
        $response_state .= "<br />Rozszerzenie SReg zwróciło element <b>$item</b> z wartością: <b>$value</b>";
    }

    // Wyświetla ew. dane zwrócone przez rozszerzenie PAPE
	$response_pape = Auth_OpenID_PAPE_Response::fromSuccessResponse($response);
	if ($response_pape){
        // strategie PAPE wpływające na uwierzytelnianie
        if ($response_pape->auth_policies){
            $response_state .= "<br />Rozszerzenie PAPE zwróciło strategie, które wpłynęły na uwierzytelnianie:";

            foreach ($response_pape->auth_policies as $uri){
                $response_state .= '- ' . htmlentities($uri);
            }
        }
        
        // Wiek uwierzytelniania serwera
        if ($response_pape->auth_age){
            $response_state .= "<br />Rozszerzenie PAPE zwróciło wiek uwierzytelniania serwera z wartością: " .
                                htmlentities($response_pape->auth_age);
        }
        
        // Poziom uwierzytelniania NIST
        if ($response_pape->nist_auth_level) {
            $response_state .= "<br />Rozszerzenie PAPE zwróciło poziom uwierzytelniania NIST serwera z wartością: " .
                                htmlentities($response_pape->nist_auth_level);
        }

	}

    // Pobiera wartości zwrócone przez rozszerzenie Attribute Exchange
    $response_ax = new Auth_OpenID_AX_FetchResponse();
    $ax_return = $response_ax->fromSuccessResponse($response);
    echo "<h1>AX</h1>";
    var_dump($ax_return);
    foreach ($ax_return->data as $item => $value){
        $response_state .= "<br />Rozszerzenie AX zwróciło element <b>$item</b> z wartością: <b>{$value[0]}</b>";
    }
}
    
print $response_state;
?>