<?php
error_reporting(E_ERROR);
ini_set("display_errors", 1);
session_start();

require_once "includes.php";  // konfiguracja i wspólne funkcje

/******************************************************************
 * Function: Tworzy żądanie
 * Description: Konstruuje żądanie OpenID przy użyciu zdefiniowanych
 *              rozszerzeń żądania
 ******************************************************************/
function make_request(){
    // Uzyskuje adres URL identyfikatora openid
    if (empty($_GET['openid_url'])) {
        $error = "Expected an OpenID URL.";
        print $error;
        exit(0);
    }
    
    $openid = $_GET['openid_url'];
    $consumer = get_consumer();
    
    // Rozpoczyna uwierzytelnianie openid
    $auth_request = $consumer->begin($openid);
    
    // Uwierzytelnienie niemożliwe
    if (!$auth_request) {
        echo "Authentication error; not a valid OpenID.";
    }
    
    // Dodaje rozszerzenia openid do żądania
    $auth_request->addExtension(attach_ax());    // attribute exchange
    $auth_request->addExtension(attach_sreg());  // simple registration
    $auth_request->addExtension(attach_pape());  // strategie PAPE
    
    $return_url = sprintf("http://%s%s/%s", $_SERVER['SERVER_NAME'], dirname($_SERVER['PHP_SELF']), FILE_COMPLETE);
    $trust_root = sprintf("http://%s%s/", $_SERVER['SERVER_NAME'], dirname($_SERVER['PHP_SELF']));
    
    // openid v1 - wysyła żądanie poprzez przkierowanie
    if ($auth_request->shouldSendRedirect()){
        $redirect_url = $auth_request->redirectURL($trust_root, $return_url);
    
        // Jeśli nie jest dostępne przekierowanie, wyświetla komunikat
        if (Auth_OpenID::isFailure($redirect_url)) { print "Nie można przekierować na serwer: " . $redirect_url->message; }
        else { header("Location: " . $redirect_url); }
        
    // openid v2 - wysyła żądanie POST za pomocą formularza JavaScriptu
    } else {
        // Konstruuje formularz na podstawie znaczników
        $form_id = 'openid_message';
        $form_html = $auth_request->htmlMarkup($trust_root, $return_url, false, array('id' => $form_id));
    
        // Jeśli nie można skonstruować formularza, wyświetla komunikat
        if (Auth_OpenID::isFailure($form_html)) { print "Nie można przekierować na serwer: " . $form_html->message; }
        else { print $form_html; }
    }
}

/******************************************************************
 * Function: Dołącza żądanie Attribute Exchange
 * Description: Tworzy żądanie rozszerzenia Attribute Exchange, aby
 *              umożliwić pobieranie rozszerzonych atrybutów profilu
 ******************************************************************/
function attach_ax(){
    // Buduje listę żądanych atrybutów
    $attribute[] = Auth_OpenID_AX_AttrInfo::make('http://axschema.org/contact/email', 1, 1, 'email');
    $attribute[] = Auth_OpenID_AX_AttrInfo::make('http://axschema.org/namePerson', 1, 1, 'fullname');
    $attribute[] = Auth_OpenID_AX_AttrInfo::make('http://axschema.org/person/gender', 1, 1, 'gender');
    $attribute[] = Auth_OpenID_AX_AttrInfo::make('http://axschema.org/media/image/default', 1, 1, 'picture');
    
    // Tworzy żądanie rozszerzenia Attribute Exchange
    $ax = new Auth_OpenID_AX_FetchRequest;
    
    // Dodaje atrybuty do żądania AX
    foreach($attribute as $attr){
        $ax->add($attr);
    }
    
    // Zwraca żądanie AX
    return $ax;
}

/******************************************************************
 * Function: Dołącza żądanie Simple Registration
 * Description: Tworzy żądanie rozszerzenia Simple Registration, aby
 *              umożliwić pobieranie prostych atrybutów profilu
 ******************************************************************/
function attach_sreg(){
    // Tworzy żądanie Simple Registration
    $sreg_request = Auth_OpenID_SRegRequest::build(
        array('nickname'),
        array('fullname', 'email'));

    // Zwraca żądanie SReg
    return $sreg_request;
}

/******************************************************************
 * Function: Dołącza żądanie PAPE 
 * Description: Tworzy żądanie rozszerzenia strategii PAPE, aby poinformować
 *              serwer o standardowych strategiach
 ******************************************************************/
function attach_pape(){
    // Odczytuje strategie PAPE przekazane za pośrednictwem formularza OpenID
    $policy_uris = $_GET['policies'];
    
    // Tworzy żądanie strategii PAPE
    $pape_request = new Auth_OpenID_PAPE_Request($policy_uris);
    
    // Zwraca żądanie PAPE
    return $pape_request;
}

// Wysyła żądanie OpenID
make_request();
?>