import cgi
import openid

import common

from openid.consumer import consumer
from openid.extensions import ax

'''
' Function: Main
' Description: Rozpoczyna proces uwierzytelniania OpenID
'''
def main():
    # uzyskuje parametry zapytania
    params = cgi.FieldStorage()
    
    # sprawdza, czy przekazano adres URL OpenID
    if not params.has_key('openid_url'):
        print_msg('Proszę podać identyfikator OpenID do sprawdzenia.', 'text/plain')
    else:
        # pobiera adres URL OpenID
        openid_url = params['openid_url'].value
        
        # tworzy bazowy obiekt konsumenta
        oidconsumer = consumer.Consumer({}, None)
        
        try:
            request = oidconsumer.begin(openid_url)
        except:
            print_msg('Błąd podczas odkrywania: ' + openid_url, 'text/plain')
        else:
            if request is None:
                print_msg('Nie znaleziono usług OpenID', 'text/plain')
            else:
                # żądanie rozszerzenia Attribute Exchange
                ax_request = ax.FetchRequest()
                ax_request.add(ax.AttrInfo('http://axschema.org/contact/email', required=False, alias='email'))
                ax_request.add(ax.AttrInfo('http://axschema.org/media/image/default', required=False, alias='picture'))
                request.addExtension(ax_request)
                
                # dodaje do adresu URL przekierowania parametry rozszerzenia oauth hybrid
                redirect_url = request.redirectURL(common.trust_root, common.return_to)
                redirect_url += '&openid.ns.oauth=http%3A%2F%2Fspecs.openid.net%2Fextensions%2Foauth%2F1.0&openid.oauth.consumer=' + common.consumer_key
                
                # print_msg(redirect_url, 'text/plain')
                print "Location: " + redirect_url
                
'''
' Function: Wyświetla komunikat
' Description: Wyświetla komunikat z przekazanym typem treści
' Inputs: msg (string) - Komunikat do wyświetlenia
'         type (string) - Stosowany typ treści (np. text/plain)
'''
def print_msg(msg, type):
    if msg is not None:
        print 'Content-Type: %s' % (type)
        print ''
        print msg

#initiate load of main()
if __name__ == '__main__':
    main()
    