<?php
error_reporting(E_ERROR);
session_start();

require_once "includes.php";  // konfiguracja i wspólne funkcje

/******************************************************************
 * Function: Wysyła żądanie
 * Description: Konstruuje żądanie OpenID przy użyciu zdefiniowanych
 *              rozszerzeń
 ******************************************************************/
function make_request(){
    // uzyskuje adres URL identyfikatora openid
    if (empty($_GET['openid_url'])) {
        $error = "Oczekiwano adresu URL OpenID.";
        print $error;
        exit(0);
    }
    
    $openid = $_GET['openid_url'];
    $consumer = get_consumer();
    
    // rozpoczyna uwierzytelnianie openid
    $auth_request = $consumer->begin($openid);
    
    // brak dostępnego uwierzytelniania
    if (!$auth_request) {
        print "Błąd uwierzytelniania; brak dostępu do OpenID.";
    }
    
    // dodaje rozszerenia openid do żądania
    $auth_request->addExtension(attach_ax());    // attribute exchange
    
    // generuje adres URL przekierowania
    $return_url = sprintf("%s%s", APP_ROOT, FILE_COMPLETE);
    $trust_root = sprintf("http://%s%s/", $_SERVER['SERVER_NAME'], dirname($_SERVER['PHP_SELF']));
    $redirect_url = $auth_request->redirectURL($trust_root, $return_url);
    
    // dołącza parametry rozszerzeń oauth do adresu URL przekierowania
    $hybrid_fields = array(
        'openid.ns.oauth' => 'http://specs.openid.net/extensions/oauth/1.0',
        'openid.oauth.consumer' => CONSUMER_KEY
    );
    $redirect_url .= '&'.http_build_query($hybrid_fields);
        
    // jeśli przekierowanie nie jest dostępne, wyświetla komunikat o błędzie
    if (Auth_OpenID::isFailure($redirect_url)) { print "Nie można przekierować na serwer: " . $redirect_url->message; }
    else { header("Location: " . $redirect_url); }
}

/******************************************************************
 * Function: Dołącza rozszerzenie Attribute Exchange
 * Description: Tworzy żądanie rozszerzenia Attribute Exchange, aby
 *              umożliwić pobranie rozszerzeonych atrybutów profilu
 ******************************************************************/
function attach_ax(){
    // buduje listę żądanych atrybutów
    $attribute[] = Auth_OpenID_AX_AttrInfo::make('http://axschema.org/contact/email', 1, 1, 'email');
    //$attribute[] = Auth_OpenID_AX_AttrInfo::make('http://axschema.org/namePerson', 1, 1, 'fullname');
    //$attribute[] = Auth_OpenID_AX_AttrInfo::make('http://axschema.org/person/gender', 1, 1, 'gender');
    //$attribute[] = Auth_OpenID_AX_AttrInfo::make('http://axschema.org/media/image/default', 1, 1, 'picture');
    
    // tworzy żądanie rozszerzenia attribute exchange
    $ax = new Auth_OpenID_AX_FetchRequest;
    
    // dodaje atrybuty do żądania rozszerzenia ax
    foreach($attribute as $attr){
        $ax->add($attr);
    }
    
    // zwraca żądanie rozszerzenia ax
    return $ax;
}

// wysyła żądanie OpenID
make_request();
?>