import sys
import cgi
import openid
import urllib
import os

from openid.consumer import consumer
from openid.extensions import pape, sreg, ax

'''
' Function: Main
' Description: Kończy proces uwierzytelniania OpenID i wyświetla wyniki
'''
def main():
    # Tworzy bazowy obiekt konsumenta
    oidconsumer = consumer.Consumer({}, None)
    
    # Tworzy zwrotny adres URL
    url = "http://%s/complete.py" % (os.environ['HTTP_HOST'])
    
    # Wyświetla typ treści na stronie
    print 'Content-Type: text/plain'
    print ''
    
    # Wyodrębnia i umieszcza w słowniku parametry łańcucha zapytania
    params = {}
    string_split = [s for s in os.environ['QUERY_STRING'].split('&') if s]
    for item in string_split:
        key,value = item.split('=')
        params[key] = urllib.unquote(value)
    
    # Kończy proces uwierzytelniania OpenID i uzyskuje identyfikator
    info = oidconsumer.complete(params, url)
    display_identifier = info.getDisplayIdentifier()
    
    # Uzyskuje odpowiedzi rozszerzeń Simple Registration i PAPE
    sreg_resp = sreg.SRegResponse.fromSuccessResponse(info)
    pape_resp = pape.Response.fromSuccessResponse(info)
    
    # Konstruuje obiekt odpowiedzi rozszerzenia Attribute Exchange
    ax_response = ax.FetchResponse.fromSuccessResponse(info)
    if ax_response:
        ax_items = {
            'email': ax_response.get('http://axschema.org/contact/email'),
            'fullname': ax_response.get('http://axschema.org/namePerson'),
            'gender': ax_response.get('http://axschema.org/person/gender'),
            'picture': ax_response.get('http://axschema.org/media/image/default')
        }
        
        print ax_items
    
    # Wyświetla wszystkie odpowiedzi OpenID
    print display_identifier
    
    if sreg_resp is not None:
        print sreg_resp
    
    if pape_resp is not None:
        print pape_resp
    
    if info.status == consumer.FAILURE and display_identifier:
        message = "Weryfikacja zakończona niepowodzeniem"
    elif info.status == consumer.SUCCESS:
        message = 'Sukces'
    elif info.status == consumer.CANCEL:
        message = 'Weryfikacja anulowana'
    elif info.status == consumer.SETUP_NEEDED:
        message = 'Potrzebna konfiguracja'
    else:
        message = 'Weryfikacja zakończona niepowodzeniem.'
    print message

if __name__ == '__main__':
    main()