<?php
require_once "Auth/OpenID/Consumer.php";    // Kod konsumenta OpenID
require_once "Auth/OpenID/FileStore.php";   // Obsługa pamięci plikowej
require_once "Auth/OpenID/SReg.php";        // Rozszerzenie Simple Registration
require_once "Auth/OpenID/PAPE.php";        // Rozszerzenie PAPE
require_once "Auth/OpenID/AX.php";          // Rozszerzenie Attribute Exchange

define('APP_ROOT', 'http://www.jcleblanc.com/projects/openid-php/');
define('FILE_COMPLETE', 'complete.php');
define('STORAGE_PATH', 'php_consumer');

/******************************************************************
 * Function: Uzyskuje obiekt konsumenta
 * Description: Tworzy pamięć plikową dla konsumenta i samego konsumenta OpenID
 ******************************************************************/
function get_consumer() {
    // Sprawdza, czy na pewno można utworzyć odpowiednią ścieżkę
    if (!file_exists(STORAGE_PATH) && !mkdir(STORAGE_PATH)){
        print "Nie można utworzyć katalogu '". STORAGE_PATH ."' dla pamięci plikowej. Proszę sprawdzić uprawnienia.";
        exit(0);
    }

    // Tworzy pamięć plikową konsumenta
    $store = new Auth_OpenID_FileStore(STORAGE_PATH);
    
    // Tworzy i zwraca obiekt konsumenta
    $consumer =& new Auth_OpenID_Consumer($store);
    return $consumer;
}
?>
