/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.progressindicator;

import android.animation.Animator;
import androidx.annotation.NonNull;
import androidx.vectordrawable.graphics.drawable.Animatable2Compat;
import com.google.android.material.progressindicator.IndeterminateDrawable;

abstract class IndeterminateAnimatorDelegate<T extends Animator> {
    protected IndeterminateDrawable drawable;
    protected final float[] segmentPositions;
    protected final int[] segmentColors;

    protected IndeterminateAnimatorDelegate(int segmentCount) {
        this.segmentPositions = new float[segmentCount * 2];
        this.segmentColors = new int[segmentCount];
    }

    protected void registerDrawable(@NonNull IndeterminateDrawable drawable2) {
        this.drawable = drawable2;
    }

    protected float getFractionInRange(int playtime, int start, int duration) {
        return (float)(playtime - start) / (float)duration;
    }

    abstract void startAnimator();

    abstract void cancelAnimatorImmediately();

    abstract void requestCancelAnimatorAfterCurrentCycle();

    public abstract void invalidateSpecValues();

    public abstract void registerAnimatorsCompleteCallback(@NonNull Animatable2Compat.AnimationCallback var1);

    public abstract void unregisterAnimatorsCompleteCallback();
}

