/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.datepicker;

import android.content.Context;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextWatcher;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.util.Pair;
import androidx.core.util.Preconditions;
import com.google.android.material.R;
import com.google.android.material.datepicker.CalendarConstraints;
import com.google.android.material.datepicker.DateFormatTextWatcher;
import com.google.android.material.datepicker.DateSelector;
import com.google.android.material.datepicker.DateStrings;
import com.google.android.material.datepicker.MaterialDatePicker;
import com.google.android.material.datepicker.OnSelectionChangedListener;
import com.google.android.material.datepicker.UtcDates;
import com.google.android.material.internal.ManufacturerUtils;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.resources.MaterialAttributes;
import com.google.android.material.textfield.TextInputLayout;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class RangeDateSelector
implements DateSelector<Pair<Long, Long>> {
    private String invalidRangeStartError;
    private final String invalidRangeEndError = " ";
    @Nullable
    private Long selectedStartItem = null;
    @Nullable
    private Long selectedEndItem = null;
    @Nullable
    private Long proposedTextStart = null;
    @Nullable
    private Long proposedTextEnd = null;
    public static final Parcelable.Creator<RangeDateSelector> CREATOR = new Parcelable.Creator<RangeDateSelector>(){

        @NonNull
        public RangeDateSelector createFromParcel(@NonNull Parcel source) {
            RangeDateSelector rangeDateSelector = new RangeDateSelector();
            rangeDateSelector.selectedStartItem = (Long)source.readValue(Long.class.getClassLoader());
            rangeDateSelector.selectedEndItem = (Long)source.readValue(Long.class.getClassLoader());
            return rangeDateSelector;
        }

        @NonNull
        public RangeDateSelector[] newArray(int size) {
            return new RangeDateSelector[size];
        }
    };

    @Override
    public void select(long selection) {
        if (this.selectedStartItem == null) {
            this.selectedStartItem = selection;
        } else if (this.selectedEndItem == null && this.isValidRange(this.selectedStartItem, selection)) {
            this.selectedEndItem = selection;
        } else {
            this.selectedEndItem = null;
            this.selectedStartItem = selection;
        }
    }

    @Override
    public boolean isSelectionComplete() {
        return this.selectedStartItem != null && this.selectedEndItem != null && this.isValidRange(this.selectedStartItem, this.selectedEndItem);
    }

    @Override
    public void setSelection(@NonNull Pair<Long, Long> selection) {
        if (selection.first != null && selection.second != null) {
            Preconditions.checkArgument((boolean)this.isValidRange((Long)selection.first, (Long)selection.second));
        }
        this.selectedStartItem = selection.first == null ? null : Long.valueOf(UtcDates.canonicalYearMonthDay((Long)selection.first));
        this.selectedEndItem = selection.second == null ? null : Long.valueOf(UtcDates.canonicalYearMonthDay((Long)selection.second));
    }

    @Override
    @NonNull
    public Pair<Long, Long> getSelection() {
        return new Pair((Object)this.selectedStartItem, (Object)this.selectedEndItem);
    }

    @Override
    @NonNull
    public Collection<Pair<Long, Long>> getSelectedRanges() {
        if (this.selectedStartItem == null || this.selectedEndItem == null) {
            return new ArrayList<Pair<Long, Long>>();
        }
        ArrayList<Pair<Long, Long>> ranges = new ArrayList<Pair<Long, Long>>();
        Pair range = new Pair((Object)this.selectedStartItem, (Object)this.selectedEndItem);
        ranges.add(range);
        return ranges;
    }

    @Override
    @NonNull
    public Collection<Long> getSelectedDays() {
        ArrayList<Long> selections = new ArrayList<Long>();
        if (this.selectedStartItem != null) {
            selections.add(this.selectedStartItem);
        }
        if (this.selectedEndItem != null) {
            selections.add(this.selectedEndItem);
        }
        return selections;
    }

    @Override
    public int getDefaultThemeResId(@NonNull Context context) {
        Resources res = context.getResources();
        DisplayMetrics display = res.getDisplayMetrics();
        int maximumDefaultFullscreenMinorAxis = res.getDimensionPixelSize(R.dimen.mtrl_calendar_maximum_default_fullscreen_minor_axis);
        int minorAxisPx = Math.min(display.widthPixels, display.heightPixels);
        int defaultThemeAttr = minorAxisPx > maximumDefaultFullscreenMinorAxis ? R.attr.materialCalendarTheme : R.attr.materialCalendarFullscreenTheme;
        return MaterialAttributes.resolveOrThrow(context, defaultThemeAttr, MaterialDatePicker.class.getCanonicalName());
    }

    @Override
    @NonNull
    public String getSelectionDisplayString(@NonNull Context context) {
        Resources res = context.getResources();
        if (this.selectedStartItem == null && this.selectedEndItem == null) {
            return res.getString(R.string.mtrl_picker_range_header_unselected);
        }
        if (this.selectedEndItem == null) {
            return res.getString(R.string.mtrl_picker_range_header_only_start_selected, new Object[]{DateStrings.getDateString(this.selectedStartItem)});
        }
        if (this.selectedStartItem == null) {
            return res.getString(R.string.mtrl_picker_range_header_only_end_selected, new Object[]{DateStrings.getDateString(this.selectedEndItem)});
        }
        Pair<String, String> dateRangeStrings = DateStrings.getDateRangeString(this.selectedStartItem, this.selectedEndItem);
        return res.getString(R.string.mtrl_picker_range_header_selected, new Object[]{dateRangeStrings.first, dateRangeStrings.second});
    }

    @Override
    public int getDefaultTitleResId() {
        return R.string.mtrl_picker_range_header_title;
    }

    @Override
    public View onCreateTextInputView(@NonNull LayoutInflater layoutInflater, @Nullable ViewGroup viewGroup, @Nullable Bundle bundle, CalendarConstraints constraints, final @NonNull OnSelectionChangedListener<Pair<Long, Long>> listener) {
        View root = layoutInflater.inflate(R.layout.mtrl_picker_text_input_date_range, viewGroup, false);
        final TextInputLayout startTextInput = (TextInputLayout)root.findViewById(R.id.mtrl_picker_text_input_range_start);
        final TextInputLayout endTextInput = (TextInputLayout)root.findViewById(R.id.mtrl_picker_text_input_range_end);
        EditText startEditText = startTextInput.getEditText();
        EditText endEditText = endTextInput.getEditText();
        if (ManufacturerUtils.isDateInputKeyboardMissingSeparatorCharacters()) {
            startEditText.setInputType(17);
            endEditText.setInputType(17);
        }
        this.invalidRangeStartError = root.getResources().getString(R.string.mtrl_picker_invalid_range);
        SimpleDateFormat format = UtcDates.getTextInputFormat();
        if (this.selectedStartItem != null) {
            startEditText.setText((CharSequence)format.format(this.selectedStartItem));
            this.proposedTextStart = this.selectedStartItem;
        }
        if (this.selectedEndItem != null) {
            endEditText.setText((CharSequence)format.format(this.selectedEndItem));
            this.proposedTextEnd = this.selectedEndItem;
        }
        String formatHint = UtcDates.getTextInputHint(root.getResources(), format);
        startTextInput.setPlaceholderText(formatHint);
        endTextInput.setPlaceholderText(formatHint);
        startEditText.addTextChangedListener((TextWatcher)new DateFormatTextWatcher(formatHint, format, startTextInput, constraints){

            @Override
            void onValidDate(@Nullable Long day) {
                RangeDateSelector.this.proposedTextStart = day;
                RangeDateSelector.this.updateIfValidTextProposal(startTextInput, endTextInput, listener);
            }

            @Override
            void onInvalidDate() {
                RangeDateSelector.this.proposedTextStart = null;
                RangeDateSelector.this.updateIfValidTextProposal(startTextInput, endTextInput, listener);
            }
        });
        endEditText.addTextChangedListener((TextWatcher)new DateFormatTextWatcher(formatHint, format, endTextInput, constraints){

            @Override
            void onValidDate(@Nullable Long day) {
                RangeDateSelector.this.proposedTextEnd = day;
                RangeDateSelector.this.updateIfValidTextProposal(startTextInput, endTextInput, listener);
            }

            @Override
            void onInvalidDate() {
                RangeDateSelector.this.proposedTextEnd = null;
                RangeDateSelector.this.updateIfValidTextProposal(startTextInput, endTextInput, listener);
            }
        });
        ViewUtils.requestFocusAndShowKeyboard((View)startEditText);
        return root;
    }

    private boolean isValidRange(long start, long end) {
        return start <= end;
    }

    private void updateIfValidTextProposal(@NonNull TextInputLayout startTextInput, @NonNull TextInputLayout endTextInput, @NonNull OnSelectionChangedListener<Pair<Long, Long>> listener) {
        if (this.proposedTextStart == null || this.proposedTextEnd == null) {
            this.clearInvalidRange(startTextInput, endTextInput);
            listener.onIncompleteSelectionChanged();
            return;
        }
        if (this.isValidRange(this.proposedTextStart, this.proposedTextEnd)) {
            this.selectedStartItem = this.proposedTextStart;
            this.selectedEndItem = this.proposedTextEnd;
            listener.onSelectionChanged(this.getSelection());
        } else {
            this.setInvalidRange(startTextInput, endTextInput);
            listener.onIncompleteSelectionChanged();
        }
    }

    private void clearInvalidRange(@NonNull TextInputLayout start, @NonNull TextInputLayout end) {
        if (start.getError() != null && this.invalidRangeStartError.contentEquals(start.getError())) {
            start.setError(null);
        }
        if (end.getError() != null && " ".contentEquals(end.getError())) {
            end.setError(null);
        }
    }

    private void setInvalidRange(@NonNull TextInputLayout start, @NonNull TextInputLayout end) {
        start.setError(this.invalidRangeStartError);
        end.setError(" ");
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeValue((Object)this.selectedStartItem);
        dest.writeValue((Object)this.selectedEndItem);
    }
}

