/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.location;

import android.location.GpsSatellite;
import android.location.GpsStatus;
import android.os.Build;
import androidx.annotation.GuardedBy;
import androidx.annotation.RestrictTo;
import androidx.core.location.GnssStatusCompat;
import androidx.core.util.Preconditions;
import java.util.Iterator;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
class GpsStatusWrapper
extends GnssStatusCompat {
    private static final int GPS_PRN_OFFSET = 0;
    private static final int GPS_PRN_COUNT = 32;
    private static final int SBAS_PRN_MIN = 33;
    private static final int SBAS_PRN_MAX = 64;
    private static final int SBAS_PRN_OFFSET = -87;
    private static final int GLONASS_PRN_OFFSET = 64;
    private static final int GLONASS_PRN_COUNT = 24;
    private static final int QZSS_SVID_MIN = 193;
    private static final int QZSS_SVID_MAX = 200;
    private static final int BEIDOU_PRN_OFFSET = 200;
    private static final int BEIDOU_PRN_COUNT = 35;
    private final GpsStatus mWrapped;
    @GuardedBy(value="mWrapped")
    private int mCachedSatelliteCount;
    @GuardedBy(value="mWrapped")
    private Iterator<GpsSatellite> mCachedIterator;
    @GuardedBy(value="mWrapped")
    private int mCachedIteratorPosition;
    @GuardedBy(value="mWrapped")
    private GpsSatellite mCachedSatellite;

    GpsStatusWrapper(GpsStatus gpsStatus) {
        this.mWrapped = Preconditions.checkNotNull(gpsStatus);
        this.mCachedSatelliteCount = -1;
        this.mCachedIterator = this.mWrapped.getSatellites().iterator();
        this.mCachedIteratorPosition = -1;
        this.mCachedSatellite = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSatelliteCount() {
        GpsStatus gpsStatus = this.mWrapped;
        synchronized (gpsStatus) {
            if (this.mCachedSatelliteCount == -1) {
                for (GpsSatellite ignored : this.mWrapped.getSatellites()) {
                    ++this.mCachedSatelliteCount;
                }
                ++this.mCachedSatelliteCount;
            }
            return this.mCachedSatelliteCount;
        }
    }

    @Override
    public int getConstellationType(int satelliteIndex) {
        if (Build.VERSION.SDK_INT < 24) {
            return 1;
        }
        return GpsStatusWrapper.getConstellationFromPrn(this.getSatellite(satelliteIndex).getPrn());
    }

    @Override
    public int getSvid(int satelliteIndex) {
        if (Build.VERSION.SDK_INT < 24) {
            return this.getSatellite(satelliteIndex).getPrn();
        }
        return GpsStatusWrapper.getSvidFromPrn(this.getSatellite(satelliteIndex).getPrn());
    }

    @Override
    public float getCn0DbHz(int satelliteIndex) {
        return this.getSatellite(satelliteIndex).getSnr();
    }

    @Override
    public float getElevationDegrees(int satelliteIndex) {
        return this.getSatellite(satelliteIndex).getElevation();
    }

    @Override
    public float getAzimuthDegrees(int satelliteIndex) {
        return this.getSatellite(satelliteIndex).getAzimuth();
    }

    @Override
    public boolean hasEphemerisData(int satelliteIndex) {
        return this.getSatellite(satelliteIndex).hasEphemeris();
    }

    @Override
    public boolean hasAlmanacData(int satelliteIndex) {
        return this.getSatellite(satelliteIndex).hasAlmanac();
    }

    @Override
    public boolean usedInFix(int satelliteIndex) {
        return this.getSatellite(satelliteIndex).usedInFix();
    }

    @Override
    public boolean hasCarrierFrequencyHz(int satelliteIndex) {
        return false;
    }

    @Override
    public float getCarrierFrequencyHz(int satelliteIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasBasebandCn0DbHz(int satelliteIndex) {
        return false;
    }

    @Override
    public float getBasebandCn0DbHz(int satelliteIndex) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GpsSatellite getSatellite(int satelliteIndex) {
        GpsSatellite satellite;
        GpsStatus gpsStatus = this.mWrapped;
        synchronized (gpsStatus) {
            if (satelliteIndex < this.mCachedIteratorPosition) {
                this.mCachedIterator = this.mWrapped.getSatellites().iterator();
                this.mCachedIteratorPosition = -1;
            }
            while (this.mCachedIteratorPosition < satelliteIndex) {
                ++this.mCachedIteratorPosition;
                if (!this.mCachedIterator.hasNext()) {
                    this.mCachedSatellite = null;
                    break;
                }
                this.mCachedSatellite = this.mCachedIterator.next();
            }
            satellite = this.mCachedSatellite;
        }
        return Preconditions.checkNotNull(satellite);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GpsStatusWrapper)) {
            return false;
        }
        GpsStatusWrapper that = (GpsStatusWrapper)o;
        return this.mWrapped.equals(that.mWrapped);
    }

    public int hashCode() {
        return this.mWrapped.hashCode();
    }

    private static int getConstellationFromPrn(int prn) {
        if (prn > 0 && prn <= 32) {
            return 1;
        }
        if (prn >= 33 && prn <= 64) {
            return 2;
        }
        if (prn > 64 && prn <= 88) {
            return 3;
        }
        if (prn > 200 && prn <= 235) {
            return 5;
        }
        if (prn >= 193 && prn <= 200) {
            return 4;
        }
        return 0;
    }

    private static int getSvidFromPrn(int prn) {
        switch (GpsStatusWrapper.getConstellationFromPrn(prn)) {
            case 2: {
                prn += 87;
                break;
            }
            case 3: {
                prn -= 64;
                break;
            }
            case 5: {
                prn -= 200;
            }
        }
        return prn;
    }
}

