/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.content;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.concurrent.futures.ResolvableFuture;
import androidx.core.app.unusedapprestrictions.IUnusedAppRestrictionsBackportCallback;
import androidx.core.app.unusedapprestrictions.IUnusedAppRestrictionsBackportService;
import androidx.core.content.PackageManagerCompat;

class UnusedAppRestrictionsBackportServiceConnection
implements ServiceConnection {
    @VisibleForTesting
    @Nullable
    IUnusedAppRestrictionsBackportService mUnusedAppRestrictionsService = null;
    @NonNull
    ResolvableFuture<Integer> mResultFuture;
    private final Context mContext;
    private boolean mHasBoundService = false;

    UnusedAppRestrictionsBackportServiceConnection(@NonNull Context context) {
        this.mContext = context;
    }

    public void onServiceConnected(ComponentName name, IBinder service) {
        this.mUnusedAppRestrictionsService = IUnusedAppRestrictionsBackportService.Stub.asInterface(service);
        try {
            this.mUnusedAppRestrictionsService.isPermissionRevocationEnabledForApp(this.getBackportCallback());
        }
        catch (RemoteException e) {
            this.mResultFuture.set((Object)0);
        }
    }

    public void onServiceDisconnected(ComponentName name) {
        this.mUnusedAppRestrictionsService = null;
    }

    public void connectAndFetchResult(@NonNull ResolvableFuture<Integer> resultFuture) {
        if (this.mHasBoundService) {
            throw new IllegalStateException("Each UnusedAppRestrictionsBackportServiceConnection can only be bound once.");
        }
        this.mHasBoundService = true;
        this.mResultFuture = resultFuture;
        Intent intent = new Intent("android.support.unusedapprestrictions.action.CustomUnusedAppRestrictionsBackportService").setPackage(PackageManagerCompat.getPermissionRevocationVerifierApp(this.mContext.getPackageManager()));
        this.mContext.bindService(intent, (ServiceConnection)this, 1);
    }

    public void disconnectFromService() {
        if (!this.mHasBoundService) {
            throw new IllegalStateException("bindService must be called before unbind");
        }
        this.mHasBoundService = false;
        this.mContext.unbindService((ServiceConnection)this);
    }

    private IUnusedAppRestrictionsBackportCallback getBackportCallback() {
        return new IUnusedAppRestrictionsBackportCallback.Stub(){

            @Override
            public void onIsPermissionRevocationEnabledForAppResult(boolean success, boolean isEnabled) throws RemoteException {
                if (success) {
                    if (isEnabled) {
                        UnusedAppRestrictionsBackportServiceConnection.this.mResultFuture.set((Object)3);
                    } else {
                        UnusedAppRestrictionsBackportServiceConnection.this.mResultFuture.set((Object)2);
                    }
                } else {
                    UnusedAppRestrictionsBackportServiceConnection.this.mResultFuture.set((Object)0);
                    Log.e((String)"PackageManagerCompat", (String)"Unable to retrieve the permission revocation setting from the backport");
                }
            }
        };
    }
}

