/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.widget;

import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.widget.TintableImageSourceView;

public class ImageViewCompat {
    @Nullable
    public static ColorStateList getImageTintList(@NonNull ImageView view) {
        if (Build.VERSION.SDK_INT >= 21) {
            return view.getImageTintList();
        }
        return view instanceof TintableImageSourceView ? ((TintableImageSourceView)view).getSupportImageTintList() : null;
    }

    public static void setImageTintList(@NonNull ImageView view, @Nullable ColorStateList tintList) {
        if (Build.VERSION.SDK_INT >= 21) {
            Drawable imageViewDrawable;
            view.setImageTintList(tintList);
            if (Build.VERSION.SDK_INT == 21 && (imageViewDrawable = view.getDrawable()) != null && view.getImageTintList() != null) {
                if (imageViewDrawable.isStateful()) {
                    imageViewDrawable.setState(view.getDrawableState());
                }
                view.setImageDrawable(imageViewDrawable);
            }
        } else if (view instanceof TintableImageSourceView) {
            ((TintableImageSourceView)view).setSupportImageTintList(tintList);
        }
    }

    @Nullable
    public static PorterDuff.Mode getImageTintMode(@NonNull ImageView view) {
        if (Build.VERSION.SDK_INT >= 21) {
            return view.getImageTintMode();
        }
        return view instanceof TintableImageSourceView ? ((TintableImageSourceView)view).getSupportImageTintMode() : null;
    }

    public static void setImageTintMode(@NonNull ImageView view, @Nullable PorterDuff.Mode mode) {
        if (Build.VERSION.SDK_INT >= 21) {
            Drawable imageViewDrawable;
            view.setImageTintMode(mode);
            if (Build.VERSION.SDK_INT == 21 && (imageViewDrawable = view.getDrawable()) != null && view.getImageTintList() != null) {
                if (imageViewDrawable.isStateful()) {
                    imageViewDrawable.setState(view.getDrawableState());
                }
                view.setImageDrawable(imageViewDrawable);
            }
        } else if (view instanceof TintableImageSourceView) {
            ((TintableImageSourceView)view).setSupportImageTintMode(mode);
        }
    }

    private ImageViewCompat() {
    }
}

