/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.view.inputmethod;

import android.annotation.SuppressLint;
import android.os.Build;
import android.os.Bundle;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.view.inputmethod.EditorInfo;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.core.util.Preconditions;

@SuppressLint(value={"PrivateConstructorForUtilityClass"})
public final class EditorInfoCompat {
    public static final int IME_FLAG_NO_PERSONALIZED_LEARNING = 0x1000000;
    public static final int IME_FLAG_FORCE_ASCII = Integer.MIN_VALUE;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String CONTENT_MIME_TYPES_KEY = "androidx.core.view.inputmethod.EditorInfoCompat.CONTENT_MIME_TYPES";
    private static final String CONTENT_MIME_TYPES_INTEROP_KEY = "android.support.v13.view.inputmethod.EditorInfoCompat.CONTENT_MIME_TYPES";
    private static final String CONTENT_SURROUNDING_TEXT_KEY = "androidx.core.view.inputmethod.EditorInfoCompat.CONTENT_SURROUNDING_TEXT";
    private static final String CONTENT_SELECTION_HEAD_KEY = "androidx.core.view.inputmethod.EditorInfoCompat.CONTENT_SELECTION_HEAD";
    private static final String CONTENT_SELECTION_END_KEY = "androidx.core.view.inputmethod.EditorInfoCompat.CONTENT_SELECTION_END";
    @VisibleForTesting
    static final int MEMORY_EFFICIENT_TEXT_LENGTH = 2048;
    @VisibleForTesting
    static final int MAX_INITIAL_SELECTION_LENGTH = 1024;

    public static void setContentMimeTypes(@NonNull EditorInfo editorInfo, @Nullable String[] contentMimeTypes) {
        if (Build.VERSION.SDK_INT >= 25) {
            editorInfo.contentMimeTypes = contentMimeTypes;
        } else {
            if (editorInfo.extras == null) {
                editorInfo.extras = new Bundle();
            }
            editorInfo.extras.putStringArray(CONTENT_MIME_TYPES_KEY, contentMimeTypes);
            editorInfo.extras.putStringArray(CONTENT_MIME_TYPES_INTEROP_KEY, contentMimeTypes);
        }
    }

    @NonNull
    public static String[] getContentMimeTypes(@NonNull EditorInfo editorInfo) {
        if (Build.VERSION.SDK_INT >= 25) {
            String[] result = editorInfo.contentMimeTypes;
            return result != null ? result : EMPTY_STRING_ARRAY;
        }
        if (editorInfo.extras == null) {
            return EMPTY_STRING_ARRAY;
        }
        String[] result = editorInfo.extras.getStringArray(CONTENT_MIME_TYPES_KEY);
        if (result == null) {
            result = editorInfo.extras.getStringArray(CONTENT_MIME_TYPES_INTEROP_KEY);
        }
        return result != null ? result : EMPTY_STRING_ARRAY;
    }

    public static void setInitialSurroundingText(@NonNull EditorInfo editorInfo, @NonNull CharSequence sourceText) {
        if (Build.VERSION.SDK_INT >= 30) {
            Api30Impl.setInitialSurroundingSubText(editorInfo, sourceText, 0);
        } else {
            EditorInfoCompat.setInitialSurroundingSubText(editorInfo, sourceText, 0);
        }
    }

    public static void setInitialSurroundingSubText(@NonNull EditorInfo editorInfo, @NonNull CharSequence subText, int subTextStart) {
        Preconditions.checkNotNull(subText);
        if (Build.VERSION.SDK_INT >= 30) {
            Api30Impl.setInitialSurroundingSubText(editorInfo, subText, subTextStart);
            return;
        }
        int subTextSelStart = editorInfo.initialSelStart > editorInfo.initialSelEnd ? editorInfo.initialSelEnd - subTextStart : editorInfo.initialSelStart - subTextStart;
        int subTextSelEnd = editorInfo.initialSelStart > editorInfo.initialSelEnd ? editorInfo.initialSelStart - subTextStart : editorInfo.initialSelEnd - subTextStart;
        int subTextLength = subText.length();
        if (subTextStart < 0 || subTextSelStart < 0 || subTextSelEnd > subTextLength) {
            EditorInfoCompat.setSurroundingText(editorInfo, null, 0, 0);
            return;
        }
        if (EditorInfoCompat.isPasswordInputType(editorInfo.inputType)) {
            EditorInfoCompat.setSurroundingText(editorInfo, null, 0, 0);
            return;
        }
        if (subTextLength <= 2048) {
            EditorInfoCompat.setSurroundingText(editorInfo, subText, subTextSelStart, subTextSelEnd);
            return;
        }
        EditorInfoCompat.trimLongSurroundingText(editorInfo, subText, subTextSelStart, subTextSelEnd);
    }

    private static void trimLongSurroundingText(EditorInfo editorInfo, CharSequence subText, int selStart, int selEnd) {
        CharSequence newInitialSurroundingText;
        int sourceSelLength = selEnd - selStart;
        int newSelLength = sourceSelLength > 1024 ? 0 : sourceSelLength;
        int subTextAfterCursorLength = subText.length() - selEnd;
        int maxLengthMinusSelection = 2048 - newSelLength;
        int possibleMaxBeforeCursorLength = Math.min(selStart, (int)(0.8 * (double)maxLengthMinusSelection));
        int newAfterCursorLength = Math.min(subTextAfterCursorLength, maxLengthMinusSelection - possibleMaxBeforeCursorLength);
        int newBeforeCursorLength = Math.min(selStart, maxLengthMinusSelection - newAfterCursorLength);
        int newBeforeCursorHead = selStart - newBeforeCursorLength;
        if (EditorInfoCompat.isCutOnSurrogate(subText, selStart - newBeforeCursorLength, 0)) {
            ++newBeforeCursorHead;
            --newBeforeCursorLength;
        }
        if (EditorInfoCompat.isCutOnSurrogate(subText, selEnd + newAfterCursorLength - 1, 1)) {
            --newAfterCursorLength;
        }
        int newTextLength = newBeforeCursorLength + newSelLength + newAfterCursorLength;
        if (newSelLength != sourceSelLength) {
            CharSequence beforeCursor = subText.subSequence(newBeforeCursorHead, newBeforeCursorHead + newBeforeCursorLength);
            CharSequence afterCursor = subText.subSequence(selEnd, selEnd + newAfterCursorLength);
            newInitialSurroundingText = TextUtils.concat((CharSequence[])new CharSequence[]{beforeCursor, afterCursor});
        } else {
            newInitialSurroundingText = subText.subSequence(newBeforeCursorHead, newBeforeCursorHead + newTextLength);
        }
        newBeforeCursorHead = 0;
        int newSelHead = newBeforeCursorHead + newBeforeCursorLength;
        EditorInfoCompat.setSurroundingText(editorInfo, newInitialSurroundingText, newSelHead, newSelHead + newSelLength);
    }

    @Nullable
    public static CharSequence getInitialTextBeforeCursor(@NonNull EditorInfo editorInfo, int length, int flags) {
        if (Build.VERSION.SDK_INT >= 30) {
            return Api30Impl.getInitialTextBeforeCursor(editorInfo, length, flags);
        }
        if (editorInfo.extras == null) {
            return null;
        }
        CharSequence surroundingText = editorInfo.extras.getCharSequence(CONTENT_SURROUNDING_TEXT_KEY);
        if (surroundingText == null) {
            return null;
        }
        int selectionHead = editorInfo.extras.getInt(CONTENT_SELECTION_HEAD_KEY);
        int textLength = Math.min(length, selectionHead);
        return (flags & 1) != 0 ? surroundingText.subSequence(selectionHead - textLength, selectionHead) : TextUtils.substring((CharSequence)surroundingText, (int)(selectionHead - textLength), (int)selectionHead);
    }

    @Nullable
    public static CharSequence getInitialSelectedText(@NonNull EditorInfo editorInfo, int flags) {
        if (Build.VERSION.SDK_INT >= 30) {
            return Api30Impl.getInitialSelectedText(editorInfo, flags);
        }
        if (editorInfo.extras == null) {
            return null;
        }
        int correctedTextSelStart = Math.min(editorInfo.initialSelStart, editorInfo.initialSelEnd);
        int correctedTextSelEnd = Math.max(editorInfo.initialSelStart, editorInfo.initialSelEnd);
        int selectionHead = editorInfo.extras.getInt(CONTENT_SELECTION_HEAD_KEY);
        int selectionEnd = editorInfo.extras.getInt(CONTENT_SELECTION_END_KEY);
        int sourceSelLength = correctedTextSelEnd - correctedTextSelStart;
        if (editorInfo.initialSelStart < 0 || editorInfo.initialSelEnd < 0 || selectionEnd - selectionHead != sourceSelLength) {
            return null;
        }
        CharSequence surroundingText = editorInfo.extras.getCharSequence(CONTENT_SURROUNDING_TEXT_KEY);
        if (surroundingText == null) {
            return null;
        }
        return (flags & 1) != 0 ? surroundingText.subSequence(selectionHead, selectionEnd) : TextUtils.substring((CharSequence)surroundingText, (int)selectionHead, (int)selectionEnd);
    }

    @Nullable
    public static CharSequence getInitialTextAfterCursor(@NonNull EditorInfo editorInfo, int length, int flags) {
        if (Build.VERSION.SDK_INT >= 30) {
            return Api30Impl.getInitialTextAfterCursor(editorInfo, length, flags);
        }
        if (editorInfo.extras == null) {
            return null;
        }
        CharSequence surroundingText = editorInfo.extras.getCharSequence(CONTENT_SURROUNDING_TEXT_KEY);
        if (surroundingText == null) {
            return null;
        }
        int selectionEnd = editorInfo.extras.getInt(CONTENT_SELECTION_END_KEY);
        int textLength = Math.min(length, surroundingText.length() - selectionEnd);
        return (flags & 1) != 0 ? surroundingText.subSequence(selectionEnd, selectionEnd + textLength) : TextUtils.substring((CharSequence)surroundingText, (int)selectionEnd, (int)(selectionEnd + textLength));
    }

    private static boolean isCutOnSurrogate(CharSequence sourceText, int cutPosition, int policy) {
        switch (policy) {
            case 0: {
                return Character.isLowSurrogate(sourceText.charAt(cutPosition));
            }
            case 1: {
                return Character.isHighSurrogate(sourceText.charAt(cutPosition));
            }
        }
        return false;
    }

    private static boolean isPasswordInputType(int inputType) {
        int variation = inputType & 0xFFF;
        return variation == 129 || variation == 225 || variation == 18;
    }

    private static void setSurroundingText(EditorInfo editorInfo, CharSequence surroundingText, int selectionHead, int selectionEnd) {
        if (editorInfo.extras == null) {
            editorInfo.extras = new Bundle();
        }
        SpannableStringBuilder surroundingTextCopy = surroundingText != null ? new SpannableStringBuilder(surroundingText) : null;
        editorInfo.extras.putCharSequence(CONTENT_SURROUNDING_TEXT_KEY, (CharSequence)surroundingTextCopy);
        editorInfo.extras.putInt(CONTENT_SELECTION_HEAD_KEY, selectionHead);
        editorInfo.extras.putInt(CONTENT_SELECTION_END_KEY, selectionEnd);
    }

    static int getProtocol(EditorInfo editorInfo) {
        if (Build.VERSION.SDK_INT >= 25) {
            return 1;
        }
        if (editorInfo.extras == null) {
            return 0;
        }
        boolean hasNewKey = editorInfo.extras.containsKey(CONTENT_MIME_TYPES_KEY);
        boolean hasOldKey = editorInfo.extras.containsKey(CONTENT_MIME_TYPES_INTEROP_KEY);
        if (hasNewKey && hasOldKey) {
            return 4;
        }
        if (hasNewKey) {
            return 3;
        }
        if (hasOldKey) {
            return 2;
        }
        return 0;
    }

    @Deprecated
    public EditorInfoCompat() {
    }

    @RequiresApi(value=30)
    private static class Api30Impl {
        private Api30Impl() {
        }

        static void setInitialSurroundingSubText(@NonNull EditorInfo editorInfo, CharSequence sourceText, int subTextStart) {
            editorInfo.setInitialSurroundingSubText(sourceText, subTextStart);
        }

        static CharSequence getInitialTextBeforeCursor(@NonNull EditorInfo editorInfo, int length, int flags) {
            return editorInfo.getInitialTextBeforeCursor(length, flags);
        }

        static CharSequence getInitialSelectedText(@NonNull EditorInfo editorInfo, int flags) {
            return editorInfo.getInitialSelectedText(flags);
        }

        static CharSequence getInitialTextAfterCursor(@NonNull EditorInfo editorInfo, int length, int flags) {
            return editorInfo.getInitialTextAfterCursor(length, flags);
        }
    }
}

