/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.progressindicator;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.util.Property;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import androidx.vectordrawable.graphics.drawable.Animatable2Compat;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.progressindicator.BaseProgressIndicatorSpec;
import com.google.android.material.progressindicator.IndeterminateAnimatorDelegate;
import com.google.android.material.progressindicator.LinearProgressIndicatorSpec;
import java.util.Arrays;

final class LinearIndeterminateContiguousAnimatorDelegate
extends IndeterminateAnimatorDelegate<ObjectAnimator> {
    private static final int TOTAL_DURATION_IN_MS = 667;
    private static final int DURATION_PER_CYCLE_IN_MS = 333;
    private ObjectAnimator animator;
    private FastOutSlowInInterpolator interpolator;
    private final BaseProgressIndicatorSpec baseSpec;
    private int newIndicatorColorIndex = 1;
    private boolean dirtyColors;
    private float animationFraction;
    private static final Property<LinearIndeterminateContiguousAnimatorDelegate, Float> ANIMATION_FRACTION = new Property<LinearIndeterminateContiguousAnimatorDelegate, Float>(Float.class, "animationFraction"){

        public Float get(LinearIndeterminateContiguousAnimatorDelegate delegate) {
            return Float.valueOf(delegate.getAnimationFraction());
        }

        public void set(LinearIndeterminateContiguousAnimatorDelegate delegate, Float value) {
            delegate.setAnimationFraction(value.floatValue());
        }
    };

    public LinearIndeterminateContiguousAnimatorDelegate(@NonNull LinearProgressIndicatorSpec spec) {
        super(3);
        this.baseSpec = spec;
        this.interpolator = new FastOutSlowInInterpolator();
    }

    @Override
    public void startAnimator() {
        this.maybeInitializeAnimators();
        this.resetPropertiesForNewStart();
        this.animator.start();
    }

    private void maybeInitializeAnimators() {
        if (this.animator == null) {
            this.animator = ObjectAnimator.ofFloat((Object)this, ANIMATION_FRACTION, (float[])new float[]{0.0f, 1.0f});
            this.animator.setDuration(333L);
            this.animator.setInterpolator(null);
            this.animator.setRepeatCount(-1);
            this.animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationRepeat(Animator animation) {
                    super.onAnimationRepeat(animation);
                    LinearIndeterminateContiguousAnimatorDelegate.this.newIndicatorColorIndex = (LinearIndeterminateContiguousAnimatorDelegate.this.newIndicatorColorIndex + 1) % ((LinearIndeterminateContiguousAnimatorDelegate)LinearIndeterminateContiguousAnimatorDelegate.this).baseSpec.indicatorColors.length;
                    LinearIndeterminateContiguousAnimatorDelegate.this.dirtyColors = true;
                }
            });
        }
    }

    @Override
    public void cancelAnimatorImmediately() {
        if (this.animator != null) {
            this.animator.cancel();
        }
    }

    @Override
    public void requestCancelAnimatorAfterCurrentCycle() {
    }

    @Override
    public void invalidateSpecValues() {
        this.resetPropertiesForNewStart();
    }

    @Override
    public void registerAnimatorsCompleteCallback(@Nullable Animatable2Compat.AnimationCallback callback) {
    }

    @Override
    public void unregisterAnimatorsCompleteCallback() {
    }

    private void updateSegmentPositions(int playtime) {
        this.segmentPositions[0] = 0.0f;
        float fraction = this.getFractionInRange(playtime, 0, 667);
        this.segmentPositions[1] = this.segmentPositions[2] = this.interpolator.getInterpolation(fraction);
        this.segmentPositions[3] = this.segmentPositions[4] = this.interpolator.getInterpolation(fraction += 0.49925038f);
        this.segmentPositions[5] = 1.0f;
    }

    private void maybeUpdateSegmentColors() {
        if (this.dirtyColors && this.segmentPositions[3] < 1.0f) {
            this.segmentColors[2] = this.segmentColors[1];
            this.segmentColors[1] = this.segmentColors[0];
            this.segmentColors[0] = MaterialColors.compositeARGBWithAlpha(this.baseSpec.indicatorColors[this.newIndicatorColorIndex], this.drawable.getAlpha());
            this.dirtyColors = false;
        }
    }

    @VisibleForTesting
    void resetPropertiesForNewStart() {
        this.dirtyColors = true;
        this.newIndicatorColorIndex = 1;
        Arrays.fill(this.segmentColors, MaterialColors.compositeARGBWithAlpha(this.baseSpec.indicatorColors[0], this.drawable.getAlpha()));
    }

    private float getAnimationFraction() {
        return this.animationFraction;
    }

    @VisibleForTesting
    void setAnimationFraction(float value) {
        this.animationFraction = value;
        int playtime = (int)(this.animationFraction * 333.0f);
        this.updateSegmentPositions(playtime);
        this.maybeUpdateSegmentColors();
        this.drawable.invalidateSelf();
    }
}

