/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.progressindicator;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.progressindicator.CircularProgressIndicatorSpec;
import com.google.android.material.progressindicator.DrawingDelegate;

final class CircularDrawingDelegate
extends DrawingDelegate<CircularProgressIndicatorSpec> {
    private int arcDirectionFactor = 1;
    private float displayedTrackThickness;
    private float displayedCornerRadius;
    private float adjustedRadius;

    public CircularDrawingDelegate(@NonNull CircularProgressIndicatorSpec spec) {
        super(spec);
    }

    @Override
    public int getPreferredWidth() {
        return this.getSize();
    }

    @Override
    public int getPreferredHeight() {
        return this.getSize();
    }

    @Override
    public void adjustCanvas(@NonNull Canvas canvas, @FloatRange(from=0.0, to=1.0) float trackThicknessFraction) {
        float outerRadiusWithInset = (float)((CircularProgressIndicatorSpec)this.spec).indicatorSize / 2.0f + (float)((CircularProgressIndicatorSpec)this.spec).indicatorInset;
        canvas.translate(outerRadiusWithInset, outerRadiusWithInset);
        canvas.rotate(-90.0f);
        canvas.clipRect(-outerRadiusWithInset, -outerRadiusWithInset, outerRadiusWithInset, outerRadiusWithInset);
        this.arcDirectionFactor = ((CircularProgressIndicatorSpec)this.spec).indicatorDirection == 0 ? 1 : -1;
        this.displayedTrackThickness = (float)((CircularProgressIndicatorSpec)this.spec).trackThickness * trackThicknessFraction;
        this.displayedCornerRadius = (float)((CircularProgressIndicatorSpec)this.spec).trackCornerRadius * trackThicknessFraction;
        this.adjustedRadius = (float)(((CircularProgressIndicatorSpec)this.spec).indicatorSize - ((CircularProgressIndicatorSpec)this.spec).trackThickness) / 2.0f;
        if (this.drawable.isShowing() && ((CircularProgressIndicatorSpec)this.spec).showAnimationBehavior == 2 || this.drawable.isHiding() && ((CircularProgressIndicatorSpec)this.spec).hideAnimationBehavior == 1) {
            this.adjustedRadius += (1.0f - trackThicknessFraction) * (float)((CircularProgressIndicatorSpec)this.spec).trackThickness / 2.0f;
        } else if (this.drawable.isShowing() && ((CircularProgressIndicatorSpec)this.spec).showAnimationBehavior == 1 || this.drawable.isHiding() && ((CircularProgressIndicatorSpec)this.spec).hideAnimationBehavior == 2) {
            this.adjustedRadius -= (1.0f - trackThicknessFraction) * (float)((CircularProgressIndicatorSpec)this.spec).trackThickness / 2.0f;
        }
    }

    @Override
    void fillIndicator(@NonNull Canvas canvas, @NonNull Paint paint, @FloatRange(from=0.0, to=1.0) float startFraction, @FloatRange(from=0.0, to=1.0) float endFraction, @ColorInt int color2) {
        if (startFraction == endFraction) {
            return;
        }
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeCap(Paint.Cap.BUTT);
        paint.setAntiAlias(true);
        paint.setColor(color2);
        paint.setStrokeWidth(this.displayedTrackThickness);
        float startDegree = startFraction * 360.0f * (float)this.arcDirectionFactor;
        float arcDegree = endFraction >= startFraction ? (endFraction - startFraction) * 360.0f * (float)this.arcDirectionFactor : (1.0f + endFraction - startFraction) * 360.0f * (float)this.arcDirectionFactor;
        RectF arcBound = new RectF(-this.adjustedRadius, -this.adjustedRadius, this.adjustedRadius, this.adjustedRadius);
        canvas.drawArc(arcBound, startDegree, arcDegree, false, paint);
        if (this.displayedCornerRadius > 0.0f && Math.abs(arcDegree) < 360.0f) {
            paint.setStyle(Paint.Style.FILL);
            this.drawRoundedEnd(canvas, paint, this.displayedTrackThickness, this.displayedCornerRadius, startDegree);
            this.drawRoundedEnd(canvas, paint, this.displayedTrackThickness, this.displayedCornerRadius, startDegree + arcDegree);
        }
    }

    @Override
    void fillTrack(@NonNull Canvas canvas, @NonNull Paint paint) {
        int trackColor = MaterialColors.compositeARGBWithAlpha(((CircularProgressIndicatorSpec)this.spec).trackColor, this.drawable.getAlpha());
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeCap(Paint.Cap.BUTT);
        paint.setAntiAlias(true);
        paint.setColor(trackColor);
        paint.setStrokeWidth(this.displayedTrackThickness);
        RectF arcBound = new RectF(-this.adjustedRadius, -this.adjustedRadius, this.adjustedRadius, this.adjustedRadius);
        canvas.drawArc(arcBound, 0.0f, 360.0f, false, paint);
    }

    private int getSize() {
        return ((CircularProgressIndicatorSpec)this.spec).indicatorSize + ((CircularProgressIndicatorSpec)this.spec).indicatorInset * 2;
    }

    private void drawRoundedEnd(Canvas canvas, Paint paint, float trackSize, float cornerRadius, float positionInDeg) {
        canvas.save();
        canvas.rotate(positionInDeg);
        RectF cornersBound = new RectF(this.adjustedRadius - trackSize / 2.0f, cornerRadius, this.adjustedRadius + trackSize / 2.0f, -cornerRadius);
        canvas.drawRoundRect(cornersBound, cornerRadius, cornerRadius, paint);
        canvas.restore();
    }
}

