/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.data;

import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.bumptech.glide.load.data.DataRewinder;
import java.io.FileDescriptor;
import java.io.IOException;

public final class ParcelFileDescriptorRewinder
implements DataRewinder<ParcelFileDescriptor> {
    private final InternalRewinder rewinder;

    public static boolean isSupported() {
        return Build.VERSION.SDK_INT >= 21;
    }

    @RequiresApi(value=21)
    public ParcelFileDescriptorRewinder(ParcelFileDescriptor parcelFileDescriptor) {
        this.rewinder = new InternalRewinder(parcelFileDescriptor);
    }

    @Override
    @NonNull
    @RequiresApi(value=21)
    public ParcelFileDescriptor rewindAndGet() throws IOException {
        return this.rewinder.rewind();
    }

    @Override
    public void cleanup() {
    }

    @RequiresApi(value=21)
    private static final class InternalRewinder {
        private final ParcelFileDescriptor parcelFileDescriptor;

        InternalRewinder(ParcelFileDescriptor parcelFileDescriptor) {
            this.parcelFileDescriptor = parcelFileDescriptor;
        }

        ParcelFileDescriptor rewind() throws IOException {
            try {
                Os.lseek((FileDescriptor)this.parcelFileDescriptor.getFileDescriptor(), (long)0L, (int)OsConstants.SEEK_SET);
            }
            catch (ErrnoException e) {
                throw new IOException(e);
            }
            return this.parcelFileDescriptor;
        }
    }

    @RequiresApi(value=21)
    public static final class Factory
    implements DataRewinder.Factory<ParcelFileDescriptor> {
        @Override
        @NonNull
        public DataRewinder<ParcelFileDescriptor> build(@NonNull ParcelFileDescriptor parcelFileDescriptor) {
            return new ParcelFileDescriptorRewinder(parcelFileDescriptor);
        }

        @Override
        @NonNull
        public Class<ParcelFileDescriptor> getDataClass() {
            return ParcelFileDescriptor.class;
        }
    }
}

