/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.transformation;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.util.AttributeSet;
import android.util.Property;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.google.android.material.animation.AnimatorSetCompat;
import com.google.android.material.animation.MotionTiming;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.google.android.material.transformation.ExpandableTransformationBehavior;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public class FabTransformationScrimBehavior
extends ExpandableTransformationBehavior {
    public static final long EXPAND_DELAY = 75L;
    public static final long EXPAND_DURATION = 150L;
    public static final long COLLAPSE_DELAY = 0L;
    public static final long COLLAPSE_DURATION = 150L;
    private final MotionTiming expandTiming = new MotionTiming(75L, 150L);
    private final MotionTiming collapseTiming = new MotionTiming(0L, 150L);

    public FabTransformationScrimBehavior() {
    }

    public FabTransformationScrimBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public boolean layoutDependsOn(CoordinatorLayout parent, View child, View dependency) {
        return dependency instanceof FloatingActionButton;
    }

    public boolean onTouchEvent(@NonNull CoordinatorLayout parent, @NonNull View child, @NonNull MotionEvent ev) {
        return super.onTouchEvent(parent, child, ev);
    }

    @Override
    @NonNull
    protected AnimatorSet onCreateExpandedStateChangeAnimation(@NonNull View dependency, final @NonNull View child, final boolean expanded, boolean isAnimating) {
        ArrayList<Animator> animations = new ArrayList<Animator>();
        ArrayList<Animator.AnimatorListener> listeners = new ArrayList<Animator.AnimatorListener>();
        this.createScrimAnimation(child, expanded, isAnimating, animations, listeners);
        AnimatorSet set = new AnimatorSet();
        AnimatorSetCompat.playTogether(set, animations);
        set.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                if (expanded) {
                    child.setVisibility(0);
                }
            }

            public void onAnimationEnd(Animator animation) {
                if (!expanded) {
                    child.setVisibility(4);
                }
            }
        });
        return set;
    }

    private void createScrimAnimation(@NonNull View child, boolean expanded, boolean currentlyAnimating, @NonNull List<Animator> animations, List<Animator.AnimatorListener> unusedListeners) {
        ObjectAnimator animator2;
        MotionTiming timing;
        MotionTiming motionTiming = timing = expanded ? this.expandTiming : this.collapseTiming;
        if (expanded) {
            if (!currentlyAnimating) {
                child.setAlpha(0.0f);
            }
            animator2 = ObjectAnimator.ofFloat((Object)child, (Property)View.ALPHA, (float[])new float[]{1.0f});
        } else {
            animator2 = ObjectAnimator.ofFloat((Object)child, (Property)View.ALPHA, (float[])new float[]{0.0f});
        }
        timing.apply((Animator)animator2);
        animations.add((Animator)animator2);
    }
}

