/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.progressindicator;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.graphics.drawable.Drawable;
import android.util.Property;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import androidx.vectordrawable.graphics.drawable.Animatable2Compat;
import com.google.android.material.animation.ArgbEvaluatorCompat;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.progressindicator.BaseProgressIndicatorSpec;
import com.google.android.material.progressindicator.CircularProgressIndicatorSpec;
import com.google.android.material.progressindicator.IndeterminateAnimatorDelegate;

final class CircularIndeterminateAnimatorDelegate
extends IndeterminateAnimatorDelegate<ObjectAnimator> {
    private static final int TOTAL_CYCLES = 4;
    private static final int TOTAL_DURATION_IN_MS = 5400;
    private static final int DURATION_TO_EXPAND_IN_MS = 667;
    private static final int DURATION_TO_COLLAPSE_IN_MS = 667;
    private static final int DURATION_TO_FADE_IN_MS = 333;
    private static final int DURATION_TO_COMPLETE_END_IN_MS = 333;
    private static final int[] DELAY_TO_EXPAND_IN_MS = new int[]{0, 1350, 2700, 4050};
    private static final int[] DELAY_TO_COLLAPSE_IN_MS = new int[]{667, 2017, 3367, 4717};
    private static final int[] DELAY_TO_FADE_IN_MS = new int[]{1000, 2350, 3700, 5050};
    private static final int TAIL_DEGREES_OFFSET = -20;
    private static final int EXTRA_DEGREES_PER_CYCLE = 250;
    private static final int CONSTANT_ROTATION_DEGREES = 1520;
    private ObjectAnimator animator;
    private ObjectAnimator completeEndAnimator;
    private final FastOutSlowInInterpolator interpolator;
    private final BaseProgressIndicatorSpec baseSpec;
    private int indicatorColorIndexOffset = 0;
    private float animationFraction;
    private float completeEndFraction;
    Animatable2Compat.AnimationCallback animatorCompleteCallback = null;
    private static final Property<CircularIndeterminateAnimatorDelegate, Float> ANIMATION_FRACTION = new Property<CircularIndeterminateAnimatorDelegate, Float>(Float.class, "animationFraction"){

        public Float get(CircularIndeterminateAnimatorDelegate delegate) {
            return Float.valueOf(delegate.getAnimationFraction());
        }

        public void set(CircularIndeterminateAnimatorDelegate delegate, Float value) {
            delegate.setAnimationFraction(value.floatValue());
        }
    };
    private static final Property<CircularIndeterminateAnimatorDelegate, Float> COMPLETE_END_FRACTION = new Property<CircularIndeterminateAnimatorDelegate, Float>(Float.class, "completeEndFraction"){

        public Float get(CircularIndeterminateAnimatorDelegate delegate) {
            return Float.valueOf(delegate.getCompleteEndFraction());
        }

        public void set(CircularIndeterminateAnimatorDelegate delegate, Float value) {
            delegate.setCompleteEndFraction(value.floatValue());
        }
    };

    public CircularIndeterminateAnimatorDelegate(@NonNull CircularProgressIndicatorSpec spec) {
        super(1);
        this.baseSpec = spec;
        this.interpolator = new FastOutSlowInInterpolator();
    }

    @Override
    void startAnimator() {
        this.maybeInitializeAnimators();
        this.resetPropertiesForNewStart();
        this.animator.start();
    }

    private void maybeInitializeAnimators() {
        if (this.animator == null) {
            this.animator = ObjectAnimator.ofFloat((Object)this, ANIMATION_FRACTION, (float[])new float[]{0.0f, 1.0f});
            this.animator.setDuration(5400L);
            this.animator.setInterpolator(null);
            this.animator.setRepeatCount(-1);
            this.animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationRepeat(Animator animation) {
                    super.onAnimationRepeat(animation);
                    CircularIndeterminateAnimatorDelegate.this.indicatorColorIndexOffset = (CircularIndeterminateAnimatorDelegate.this.indicatorColorIndexOffset + 4) % ((CircularIndeterminateAnimatorDelegate)CircularIndeterminateAnimatorDelegate.this).baseSpec.indicatorColors.length;
                }
            });
        }
        if (this.completeEndAnimator == null) {
            this.completeEndAnimator = ObjectAnimator.ofFloat((Object)this, COMPLETE_END_FRACTION, (float[])new float[]{0.0f, 1.0f});
            this.completeEndAnimator.setDuration(333L);
            this.completeEndAnimator.setInterpolator((TimeInterpolator)this.interpolator);
            this.completeEndAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    CircularIndeterminateAnimatorDelegate.this.cancelAnimatorImmediately();
                    if (CircularIndeterminateAnimatorDelegate.this.animatorCompleteCallback != null) {
                        CircularIndeterminateAnimatorDelegate.this.animatorCompleteCallback.onAnimationEnd((Drawable)CircularIndeterminateAnimatorDelegate.this.drawable);
                    }
                }
            });
        }
    }

    @Override
    void cancelAnimatorImmediately() {
        if (this.animator != null) {
            this.animator.cancel();
        }
    }

    @Override
    void requestCancelAnimatorAfterCurrentCycle() {
        if (this.completeEndAnimator == null || this.completeEndAnimator.isRunning()) {
            return;
        }
        if (this.drawable.isVisible()) {
            this.completeEndAnimator.start();
        } else {
            this.cancelAnimatorImmediately();
        }
    }

    @Override
    public void invalidateSpecValues() {
        this.resetPropertiesForNewStart();
    }

    @Override
    public void registerAnimatorsCompleteCallback(@NonNull Animatable2Compat.AnimationCallback callback) {
        this.animatorCompleteCallback = callback;
    }

    @Override
    public void unregisterAnimatorsCompleteCallback() {
        this.animatorCompleteCallback = null;
    }

    private void updateSegmentPositions(int playtime) {
        this.segmentPositions[0] = 1520.0f * this.animationFraction + -20.0f;
        this.segmentPositions[1] = 1520.0f * this.animationFraction;
        for (int cycleIndex = 0; cycleIndex < 4; ++cycleIndex) {
            float fraction = this.getFractionInRange(playtime, DELAY_TO_EXPAND_IN_MS[cycleIndex], 667);
            this.segmentPositions[1] = this.segmentPositions[1] + this.interpolator.getInterpolation(fraction) * 250.0f;
            fraction = this.getFractionInRange(playtime, DELAY_TO_COLLAPSE_IN_MS[cycleIndex], 667);
            this.segmentPositions[0] = this.segmentPositions[0] + this.interpolator.getInterpolation(fraction) * 250.0f;
        }
        this.segmentPositions[0] = this.segmentPositions[0] + (this.segmentPositions[1] - this.segmentPositions[0]) * this.completeEndFraction;
        this.segmentPositions[0] = this.segmentPositions[0] / 360.0f;
        this.segmentPositions[1] = this.segmentPositions[1] / 360.0f;
    }

    private void maybeUpdateSegmentColors(int playtime) {
        for (int cycleIndex = 0; cycleIndex < 4; ++cycleIndex) {
            float timeFraction = this.getFractionInRange(playtime, DELAY_TO_FADE_IN_MS[cycleIndex], 333);
            if (!(timeFraction >= 0.0f) || !(timeFraction <= 1.0f)) continue;
            int startColorIndex = (cycleIndex + this.indicatorColorIndexOffset) % this.baseSpec.indicatorColors.length;
            int endColorIndex = (startColorIndex + 1) % this.baseSpec.indicatorColors.length;
            int startColor = MaterialColors.compositeARGBWithAlpha(this.baseSpec.indicatorColors[startColorIndex], this.drawable.getAlpha());
            int endColor = MaterialColors.compositeARGBWithAlpha(this.baseSpec.indicatorColors[endColorIndex], this.drawable.getAlpha());
            float colorFraction = this.interpolator.getInterpolation(timeFraction);
            this.segmentColors[0] = ArgbEvaluatorCompat.getInstance().evaluate(colorFraction, startColor, endColor);
            break;
        }
    }

    @VisibleForTesting
    void resetPropertiesForNewStart() {
        this.indicatorColorIndexOffset = 0;
        this.segmentColors[0] = MaterialColors.compositeARGBWithAlpha(this.baseSpec.indicatorColors[0], this.drawable.getAlpha());
        this.completeEndFraction = 0.0f;
    }

    private float getAnimationFraction() {
        return this.animationFraction;
    }

    @VisibleForTesting
    void setAnimationFraction(float fraction) {
        this.animationFraction = fraction;
        int playtime = (int)(this.animationFraction * 5400.0f);
        this.updateSegmentPositions(playtime);
        this.maybeUpdateSegmentColors(playtime);
        this.drawable.invalidateSelf();
    }

    private float getCompleteEndFraction() {
        return this.completeEndFraction;
    }

    private void setCompleteEndFraction(float fraction) {
        this.completeEndFraction = fraction;
    }
}

