/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.progressindicator;

import android.content.ContentResolver;
import android.os.Build;
import android.provider.Settings;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class AnimatorDurationScaleProvider {
    private static float defaultSystemAnimatorDurationScale = 1.0f;

    public float getSystemAnimatorDurationScale(@NonNull ContentResolver contentResolver) {
        if (Build.VERSION.SDK_INT >= 17) {
            return Settings.Global.getFloat((ContentResolver)contentResolver, (String)"animator_duration_scale", (float)1.0f);
        }
        if (Build.VERSION.SDK_INT == 16) {
            return Settings.System.getFloat((ContentResolver)contentResolver, (String)"animator_duration_scale", (float)1.0f);
        }
        return defaultSystemAnimatorDurationScale;
    }

    @VisibleForTesting
    public static void setDefaultSystemAnimatorDurationScale(float scale) {
        defaultSystemAnimatorDurationScale = scale;
    }
}

