/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.floatingactionbutton;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.util.Property;
import android.view.View;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.animation.AnimatorSetCompat;
import com.google.android.material.animation.MotionSpec;
import com.google.android.material.floatingactionbutton.AnimatorTracker;
import com.google.android.material.floatingactionbutton.ExtendedFloatingActionButton;
import com.google.android.material.floatingactionbutton.MotionStrategy;
import java.util.ArrayList;
import java.util.List;

abstract class BaseMotionStrategy
implements MotionStrategy {
    private final Context context;
    @NonNull
    private final ExtendedFloatingActionButton fab;
    private final ArrayList<Animator.AnimatorListener> listeners = new ArrayList();
    private final AnimatorTracker tracker;
    @Nullable
    private MotionSpec defaultMotionSpec;
    @Nullable
    private MotionSpec motionSpec;

    BaseMotionStrategy(@NonNull ExtendedFloatingActionButton fab, AnimatorTracker tracker) {
        this.fab = fab;
        this.context = fab.getContext();
        this.tracker = tracker;
    }

    @Override
    public final void setMotionSpec(@Nullable MotionSpec motionSpec) {
        this.motionSpec = motionSpec;
    }

    @Override
    public final MotionSpec getCurrentMotionSpec() {
        if (this.motionSpec != null) {
            return this.motionSpec;
        }
        if (this.defaultMotionSpec == null) {
            this.defaultMotionSpec = MotionSpec.createFromResource(this.context, this.getDefaultMotionSpecResource());
        }
        return (MotionSpec)Preconditions.checkNotNull((Object)this.defaultMotionSpec);
    }

    @Override
    public final void addAnimationListener(@NonNull Animator.AnimatorListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public final void removeAnimationListener(@NonNull Animator.AnimatorListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    @NonNull
    public final List<Animator.AnimatorListener> getListeners() {
        return this.listeners;
    }

    @Override
    @Nullable
    public MotionSpec getMotionSpec() {
        return this.motionSpec;
    }

    @Override
    @CallSuper
    public void onAnimationStart(Animator animator2) {
        this.tracker.onNextAnimationStart(animator2);
    }

    @Override
    @CallSuper
    public void onAnimationEnd() {
        this.tracker.clear();
    }

    @Override
    @CallSuper
    public void onAnimationCancel() {
        this.tracker.clear();
    }

    @Override
    public AnimatorSet createAnimator() {
        return this.createAnimator(this.getCurrentMotionSpec());
    }

    @NonNull
    AnimatorSet createAnimator(@NonNull MotionSpec spec) {
        ArrayList<Animator> animators = new ArrayList<Animator>();
        if (spec.hasPropertyValues("opacity")) {
            animators.add((Animator)spec.getAnimator("opacity", this.fab, View.ALPHA));
        }
        if (spec.hasPropertyValues("scale")) {
            animators.add((Animator)spec.getAnimator("scale", this.fab, View.SCALE_Y));
            animators.add((Animator)spec.getAnimator("scale", this.fab, View.SCALE_X));
        }
        if (spec.hasPropertyValues("width")) {
            animators.add((Animator)spec.getAnimator("width", this.fab, ExtendedFloatingActionButton.WIDTH));
        }
        if (spec.hasPropertyValues("height")) {
            animators.add((Animator)spec.getAnimator("height", this.fab, ExtendedFloatingActionButton.HEIGHT));
        }
        if (spec.hasPropertyValues("paddingStart")) {
            animators.add((Animator)spec.getAnimator("paddingStart", this.fab, ExtendedFloatingActionButton.PADDING_START));
        }
        if (spec.hasPropertyValues("paddingEnd")) {
            animators.add((Animator)spec.getAnimator("paddingEnd", this.fab, ExtendedFloatingActionButton.PADDING_END));
        }
        if (spec.hasPropertyValues("labelOpacity")) {
            ObjectAnimator animator2 = spec.getAnimator("labelOpacity", this.fab, new Property<ExtendedFloatingActionButton, Float>(Float.class, "LABEL_OPACITY_PROPERTY"){

                public Float get(ExtendedFloatingActionButton object) {
                    int originalOpacity = Color.alpha((int)object.originalTextCsl.getColorForState(object.getDrawableState(), ((BaseMotionStrategy)BaseMotionStrategy.this).fab.originalTextCsl.getDefaultColor()));
                    float currentOpacity = (float)Color.alpha((int)object.getCurrentTextColor()) / 255.0f;
                    return Float.valueOf(AnimationUtils.lerp(0.0f, 1.0f, currentOpacity / (float)originalOpacity));
                }

                public void set(ExtendedFloatingActionButton object, Float value) {
                    int originalColor = object.originalTextCsl.getColorForState(object.getDrawableState(), ((BaseMotionStrategy)BaseMotionStrategy.this).fab.originalTextCsl.getDefaultColor());
                    float interpolatedValue = AnimationUtils.lerp(0.0f, (float)Color.alpha((int)originalColor) / 255.0f, value.floatValue());
                    int alphaColor = Color.argb((int)((int)(interpolatedValue * 255.0f)), (int)Color.red((int)originalColor), (int)Color.green((int)originalColor), (int)Color.blue((int)originalColor));
                    ColorStateList csl = ColorStateList.valueOf((int)alphaColor);
                    if (value.floatValue() == 1.0f) {
                        object.silentlyUpdateTextColor(object.originalTextCsl);
                    } else {
                        object.silentlyUpdateTextColor(csl);
                    }
                }
            });
            animators.add((Animator)animator2);
        }
        AnimatorSet set = new AnimatorSet();
        AnimatorSetCompat.playTogether(set, animators);
        return set;
    }
}

