/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.color;

import android.content.Context;
import android.util.Pair;
import androidx.annotation.ColorInt;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class ColorResourcesTableCreator {
    private static final short HEADER_TYPE_RES_TABLE = 2;
    private static final short HEADER_TYPE_STRING_POOL = 1;
    private static final short HEADER_TYPE_PACKAGE = 512;
    private static final short HEADER_TYPE_TYPE = 513;
    private static final short HEADER_TYPE_TYPE_SPEC = 514;
    private static final byte TYPE_ID_COLOR = 6;
    private static final byte ANDROID_PACKAGE_ID = 1;
    private static final byte APPLICATION_PACKAGE_ID = 127;
    private static final PackageInfo ANDROID_PACKAGE_INFO = new PackageInfo(1, "android");
    private static final Comparator<ColorResource> COLOR_RESOURCE_COMPARATOR = new Comparator<ColorResource>(){

        @Override
        public int compare(ColorResource res1, ColorResource res2) {
            return res1.entryId - res2.entryId;
        }
    };

    private ColorResourcesTableCreator() {
    }

    static byte[] create(Context context, Map<Integer, Integer> colorMapping) throws IOException {
        PackageInfo applicationPackageInfo = new PackageInfo(127, context.getPackageName());
        HashMap<PackageInfo, List<ColorResource>> colorResourceMap = new HashMap<PackageInfo, List<ColorResource>>();
        for (Map.Entry<Integer, Integer> entry : colorMapping.entrySet()) {
            PackageInfo packageInfo;
            ColorResource colorResource = new ColorResource(entry.getKey(), context.getResources().getResourceName(entry.getKey().intValue()), entry.getValue());
            if (colorResource.typeId != 6) {
                throw new IllegalArgumentException("Non color resource found: " + colorResource.name);
            }
            if (colorResource.packageId == 1) {
                packageInfo = ANDROID_PACKAGE_INFO;
            } else if (colorResource.packageId == 127) {
                packageInfo = applicationPackageInfo;
            } else {
                throw new IllegalArgumentException("Not supported with unknown package id: " + colorResource.packageId);
            }
            if (!colorResourceMap.containsKey(packageInfo)) {
                colorResourceMap.put(packageInfo, new ArrayList());
            }
            ((List)colorResourceMap.get(packageInfo)).add(colorResource);
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        new ResTable(colorResourceMap).writeTo(outputStream);
        return outputStream.toByteArray();
    }

    private static byte[] shortToByteArray(short value) {
        return new byte[]{(byte)(value & 0xFF), (byte)(value >> 8 & 0xFF)};
    }

    private static byte[] charToByteArray(char value) {
        return new byte[]{(byte)(value & 0xFF), (byte)(value >> 8 & 0xFF)};
    }

    private static byte[] intToByteArray(int value) {
        return new byte[]{(byte)(value & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 24 & 0xFF)};
    }

    private static byte[] stringToByteArray(String value) {
        char[] chars = value.toCharArray();
        byte[] bytes = new byte[chars.length * 2 + 4];
        byte[] lengthBytes = ColorResourcesTableCreator.shortToByteArray((short)chars.length);
        bytes[0] = lengthBytes[0];
        bytes[1] = lengthBytes[1];
        for (int i = 0; i < chars.length; ++i) {
            byte[] charBytes = ColorResourcesTableCreator.charToByteArray(chars[i]);
            bytes[i * 2 + 2] = charBytes[0];
            bytes[i * 2 + 3] = charBytes[1];
        }
        bytes[bytes.length - 2] = 0;
        bytes[bytes.length - 1] = 0;
        return bytes;
    }

    private static byte[] stringToByteArrayUtf8(String value) {
        byte[] rawBytes = value.getBytes(Charset.forName("UTF-8"));
        byte stringLength = (byte)rawBytes.length;
        byte[] bytes = new byte[rawBytes.length + 3];
        System.arraycopy(rawBytes, 0, bytes, 2, stringLength);
        bytes[0] = bytes[1] = stringLength;
        bytes[bytes.length - 1] = 0;
        return bytes;
    }

    static class ColorResource {
        private final byte packageId;
        private final byte typeId;
        private final short entryId;
        private final String name;
        @ColorInt
        private final int value;

        ColorResource(int id2, String name, int value) {
            this.name = name;
            this.value = value;
            this.entryId = (short)(id2 & 0xFFFF);
            this.typeId = (byte)(id2 >> 16 & 0xFF);
            this.packageId = (byte)(id2 >> 24 & 0xFF);
        }
    }

    static class PackageInfo {
        private final int id;
        private final String name;

        PackageInfo(int id2, String name) {
            this.id = id2;
            this.name = name;
        }
    }

    private static class ResEntry {
        private static final short ENTRY_SIZE = 8;
        private static final short FLAG_PUBLIC = 2;
        private static final short VALUE_SIZE = 8;
        private static final byte DATA_TYPE_AARRGGBB = 28;
        private static final int SIZE = 16;
        private final int keyStringIndex;
        private final int data;

        ResEntry(int keyStringIndex, @ColorInt int data) {
            this.keyStringIndex = keyStringIndex;
            this.data = data;
        }

        void writeTo(ByteArrayOutputStream outputStream) throws IOException {
            outputStream.write(ColorResourcesTableCreator.shortToByteArray((short)8));
            outputStream.write(ColorResourcesTableCreator.shortToByteArray((short)2));
            outputStream.write(ColorResourcesTableCreator.intToByteArray(this.keyStringIndex));
            outputStream.write(ColorResourcesTableCreator.shortToByteArray((short)8));
            outputStream.write(new byte[]{0, 28});
            outputStream.write(ColorResourcesTableCreator.intToByteArray(this.data));
        }
    }

    private static class TypeChunk {
        private static final int OFFSET_NO_ENTRY = -1;
        private static final short HEADER_SIZE = 84;
        private static final byte CONFIG_SIZE = 64;
        private final ResChunkHeader header;
        private final int entryCount;
        private final byte[] config = new byte[64];
        private final int[] offsetTable;
        private final ResEntry[] resEntries;

        TypeChunk(List<ColorResource> colorResources, Set<Short> entryIds, int entryCount) {
            this.entryCount = entryCount;
            this.config[0] = 64;
            this.resEntries = new ResEntry[colorResources.size()];
            for (int index = 0; index < colorResources.size(); ++index) {
                ColorResource colorResource = colorResources.get(index);
                this.resEntries[index] = new ResEntry(index, colorResource.value);
            }
            this.offsetTable = new int[entryCount];
            int currentOffset = 0;
            for (short entryId = 0; entryId < entryCount; entryId = (short)(entryId + 1)) {
                if (entryIds.contains(entryId)) {
                    this.offsetTable[entryId] = currentOffset;
                    currentOffset += 16;
                    continue;
                }
                this.offsetTable[entryId] = -1;
            }
            this.header = new ResChunkHeader(513, 84, this.getChunkSize());
        }

        void writeTo(ByteArrayOutputStream outputStream) throws IOException {
            this.header.writeTo(outputStream);
            outputStream.write(new byte[]{6, 0, 0, 0});
            outputStream.write(ColorResourcesTableCreator.intToByteArray(this.entryCount));
            outputStream.write(ColorResourcesTableCreator.intToByteArray(this.getEntryStart()));
            outputStream.write(this.config);
            for (int offset : this.offsetTable) {
                outputStream.write(ColorResourcesTableCreator.intToByteArray(offset));
            }
            for (ResEntry entry : this.resEntries) {
                entry.writeTo(outputStream);
            }
        }

        int getChunkSize() {
            return this.getEntryStart() + this.resEntries.length * 16;
        }

        private int getEntryStart() {
            return 84 + this.getOffsetTableSize();
        }

        private int getOffsetTableSize() {
            return this.offsetTable.length * 4;
        }
    }

    private static class TypeSpecChunk {
        private static final short HEADER_SIZE = 16;
        private static final int SPEC_PUBLIC = 0x40000000;
        private final ResChunkHeader header;
        private final int entryCount;
        private final int[] entryFlags;
        private final TypeChunk typeChunk;

        TypeSpecChunk(List<ColorResource> colorResources) {
            this.entryCount = colorResources.get(colorResources.size() - 1).entryId + 1;
            HashSet<Short> validEntryIds = new HashSet<Short>();
            for (ColorResource colorResource : colorResources) {
                validEntryIds.add(colorResource.entryId);
            }
            this.entryFlags = new int[this.entryCount];
            for (short entryId = 0; entryId < this.entryCount; entryId = (short)(entryId + 1)) {
                if (!validEntryIds.contains(entryId)) continue;
                this.entryFlags[entryId] = 0x40000000;
            }
            this.header = new ResChunkHeader(514, 16, this.getChunkSize());
            this.typeChunk = new TypeChunk(colorResources, validEntryIds, this.entryCount);
        }

        void writeTo(ByteArrayOutputStream outputStream) throws IOException {
            this.header.writeTo(outputStream);
            outputStream.write(new byte[]{6, 0, 0, 0});
            outputStream.write(ColorResourcesTableCreator.intToByteArray(this.entryCount));
            for (int entryFlag : this.entryFlags) {
                outputStream.write(ColorResourcesTableCreator.intToByteArray(entryFlag));
            }
            this.typeChunk.writeTo(outputStream);
        }

        int getChunkSizeWithTypeChunk() {
            return this.getChunkSize() + this.typeChunk.getChunkSize();
        }

        private int getChunkSize() {
            return 16 + this.entryCount * 4;
        }
    }

    private static class PackageChunk {
        private static final short HEADER_SIZE = 288;
        private static final int PACKAGE_NAME_MAX_LENGTH = 128;
        private final ResChunkHeader header;
        private final PackageInfo packageInfo;
        private final StringPoolChunk typeStrings;
        private final StringPoolChunk keyStrings;
        private final TypeSpecChunk typeSpecChunk;

        PackageChunk(PackageInfo packageInfo, List<ColorResource> colorResources) {
            this.packageInfo = packageInfo;
            this.typeStrings = new StringPoolChunk(false, "?1", "?2", "?3", "?4", "?5", "color");
            String[] keys = new String[colorResources.size()];
            for (int i = 0; i < colorResources.size(); ++i) {
                keys[i] = colorResources.get(i).name;
            }
            this.keyStrings = new StringPoolChunk(true, keys);
            this.typeSpecChunk = new TypeSpecChunk(colorResources);
            this.header = new ResChunkHeader(512, 288, this.getChunkSize());
        }

        void writeTo(ByteArrayOutputStream outputStream) throws IOException {
            this.header.writeTo(outputStream);
            outputStream.write(ColorResourcesTableCreator.intToByteArray(this.packageInfo.id));
            char[] packageName = this.packageInfo.name.toCharArray();
            for (int i = 0; i < 128; ++i) {
                if (i < packageName.length) {
                    outputStream.write(ColorResourcesTableCreator.charToByteArray(packageName[i]));
                    continue;
                }
                outputStream.write(ColorResourcesTableCreator.charToByteArray('\u0000'));
            }
            outputStream.write(ColorResourcesTableCreator.intToByteArray(288));
            outputStream.write(ColorResourcesTableCreator.intToByteArray(0));
            outputStream.write(ColorResourcesTableCreator.intToByteArray(288 + this.typeStrings.getChunkSize()));
            outputStream.write(ColorResourcesTableCreator.intToByteArray(0));
            outputStream.write(ColorResourcesTableCreator.intToByteArray(0));
            this.typeStrings.writeTo(outputStream);
            this.keyStrings.writeTo(outputStream);
            this.typeSpecChunk.writeTo(outputStream);
        }

        int getChunkSize() {
            return 288 + this.typeStrings.getChunkSize() + this.keyStrings.getChunkSize() + this.typeSpecChunk.getChunkSizeWithTypeChunk();
        }
    }

    private static class StringStyledSpan {
        private byte[] styleString;
        private int nameReference;
        private int firstCharacterIndex;
        private int lastCharacterIndex;

        private StringStyledSpan() {
        }

        void writeTo(ByteArrayOutputStream outputStream) throws IOException {
            outputStream.write(ColorResourcesTableCreator.intToByteArray(this.nameReference));
            outputStream.write(ColorResourcesTableCreator.intToByteArray(this.firstCharacterIndex));
            outputStream.write(ColorResourcesTableCreator.intToByteArray(this.lastCharacterIndex));
        }
    }

    private static class StringPoolChunk {
        private static final short HEADER_SIZE = 28;
        private static final int FLAG_UTF8 = 256;
        private static final int STYLED_SPAN_LIST_END = -1;
        private final ResChunkHeader header;
        private final int stringCount;
        private final int styledSpanCount;
        private final int stringsStart;
        private final int styledSpansStart;
        private final List<Integer> stringIndex = new ArrayList<Integer>();
        private final List<Integer> styledSpanIndex = new ArrayList<Integer>();
        private final List<byte[]> strings = new ArrayList<byte[]>();
        private final List<List<StringStyledSpan>> styledSpans = new ArrayList<List<StringStyledSpan>>();
        private final boolean utf8Encode;
        private final int stringsPaddingSize;
        private final int chunkSize;

        StringPoolChunk(String ... rawStrings) {
            this(false, rawStrings);
        }

        StringPoolChunk(boolean utf8, String ... rawStrings) {
            boolean hasStyledSpans;
            this.utf8Encode = utf8;
            int stringOffset = 0;
            for (String string2 : rawStrings) {
                Pair<byte[], List<StringStyledSpan>> processedString = this.processString(string2);
                this.stringIndex.add(stringOffset);
                stringOffset += ((byte[])processedString.first).length;
                this.strings.add((byte[])processedString.first);
                this.styledSpans.add((List<StringStyledSpan>)processedString.second);
            }
            int styledSpanOffset = 0;
            for (List<StringStyledSpan> styledSpanList : this.styledSpans) {
                for (StringStyledSpan styledSpan : styledSpanList) {
                    this.stringIndex.add(stringOffset);
                    stringOffset += styledSpan.styleString.length;
                    this.strings.add(styledSpan.styleString);
                }
                this.styledSpanIndex.add(styledSpanOffset);
                styledSpanOffset += styledSpanList.size() * 12 + 4;
            }
            int stringOffsetResidue = stringOffset % 4;
            this.stringsPaddingSize = stringOffsetResidue == 0 ? 0 : 4 - stringOffsetResidue;
            this.stringCount = this.strings.size();
            this.styledSpanCount = this.strings.size() - rawStrings.length;
            boolean bl = hasStyledSpans = this.strings.size() - rawStrings.length > 0;
            if (!hasStyledSpans) {
                this.styledSpanIndex.clear();
                this.styledSpans.clear();
            }
            this.stringsStart = 28 + this.stringCount * 4 + this.styledSpanIndex.size() * 4;
            int stringsSize = stringOffset + this.stringsPaddingSize;
            this.styledSpansStart = hasStyledSpans ? this.stringsStart + stringsSize : 0;
            this.chunkSize = this.stringsStart + stringsSize + (hasStyledSpans ? styledSpanOffset : 0);
            this.header = new ResChunkHeader(1, 28, this.chunkSize);
        }

        void writeTo(ByteArrayOutputStream outputStream) throws IOException {
            this.header.writeTo(outputStream);
            outputStream.write(ColorResourcesTableCreator.intToByteArray(this.stringCount));
            outputStream.write(ColorResourcesTableCreator.intToByteArray(this.styledSpanCount));
            outputStream.write(ColorResourcesTableCreator.intToByteArray(this.utf8Encode ? 256 : 0));
            outputStream.write(ColorResourcesTableCreator.intToByteArray(this.stringsStart));
            outputStream.write(ColorResourcesTableCreator.intToByteArray(this.styledSpansStart));
            for (Integer n : this.stringIndex) {
                outputStream.write(ColorResourcesTableCreator.intToByteArray(n));
            }
            for (Integer n : this.styledSpanIndex) {
                outputStream.write(ColorResourcesTableCreator.intToByteArray(n));
            }
            for (byte[] byArray : this.strings) {
                outputStream.write(byArray);
            }
            if (this.stringsPaddingSize > 0) {
                outputStream.write(new byte[this.stringsPaddingSize]);
            }
            for (List list : this.styledSpans) {
                for (StringStyledSpan styledSpan : list) {
                    styledSpan.writeTo(outputStream);
                }
                outputStream.write(ColorResourcesTableCreator.intToByteArray(-1));
            }
        }

        int getChunkSize() {
            return this.chunkSize;
        }

        private Pair<byte[], List<StringStyledSpan>> processString(String rawString) {
            return new Pair((Object)(this.utf8Encode ? ColorResourcesTableCreator.stringToByteArrayUtf8(rawString) : ColorResourcesTableCreator.stringToByteArray(rawString)), Collections.emptyList());
        }
    }

    private static class ResChunkHeader {
        private final short type;
        private final short headerSize;
        private final int chunkSize;

        ResChunkHeader(short type, short headerSize, int chunkSize) {
            this.type = type;
            this.headerSize = headerSize;
            this.chunkSize = chunkSize;
        }

        void writeTo(ByteArrayOutputStream outputStream) throws IOException {
            outputStream.write(ColorResourcesTableCreator.shortToByteArray(this.type));
            outputStream.write(ColorResourcesTableCreator.shortToByteArray(this.headerSize));
            outputStream.write(ColorResourcesTableCreator.intToByteArray(this.chunkSize));
        }
    }

    private static class ResTable {
        private static final short HEADER_SIZE = 12;
        private final ResChunkHeader header;
        private final int packageCount;
        private final StringPoolChunk stringPool;
        private final List<PackageChunk> packageChunks = new ArrayList<PackageChunk>();

        ResTable(Map<PackageInfo, List<ColorResource>> colorResourceMap) {
            this.packageCount = colorResourceMap.size();
            this.stringPool = new StringPoolChunk(new String[0]);
            for (Map.Entry<PackageInfo, List<ColorResource>> entry : colorResourceMap.entrySet()) {
                List<ColorResource> colorResources = entry.getValue();
                Collections.sort(colorResources, COLOR_RESOURCE_COMPARATOR);
                this.packageChunks.add(new PackageChunk(entry.getKey(), colorResources));
            }
            this.header = new ResChunkHeader(2, 12, this.getOverallSize());
        }

        void writeTo(ByteArrayOutputStream outputStream) throws IOException {
            this.header.writeTo(outputStream);
            outputStream.write(ColorResourcesTableCreator.intToByteArray(this.packageCount));
            this.stringPool.writeTo(outputStream);
            for (PackageChunk packageChunk : this.packageChunks) {
                packageChunk.writeTo(outputStream);
            }
        }

        private int getOverallSize() {
            int packageChunkSize = 0;
            for (PackageChunk packageChunk : this.packageChunks) {
                packageChunkSize += packageChunk.getChunkSize();
            }
            return 12 + this.stringPool.getChunkSize() + packageChunkSize;
        }
    }
}

