/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.bottomnavigation;

import android.content.Context;
import android.content.res.Resources;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.appcompat.view.menu.MenuBuilder;
import androidx.core.view.ViewCompat;
import com.google.android.material.R;
import com.google.android.material.bottomnavigation.BottomNavigationItemView;
import com.google.android.material.navigation.NavigationBarItemView;
import com.google.android.material.navigation.NavigationBarMenuView;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class BottomNavigationMenuView
extends NavigationBarMenuView {
    private final int inactiveItemMaxWidth;
    private final int inactiveItemMinWidth;
    private final int activeItemMaxWidth;
    private final int activeItemMinWidth;
    private boolean itemHorizontalTranslationEnabled;
    private int[] tempChildWidths;

    public BottomNavigationMenuView(@NonNull Context context) {
        super(context);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
        params.gravity = 17;
        this.setLayoutParams((ViewGroup.LayoutParams)params);
        Resources res = this.getResources();
        this.inactiveItemMaxWidth = res.getDimensionPixelSize(R.dimen.design_bottom_navigation_item_max_width);
        this.inactiveItemMinWidth = res.getDimensionPixelSize(R.dimen.design_bottom_navigation_item_min_width);
        this.activeItemMaxWidth = res.getDimensionPixelSize(R.dimen.design_bottom_navigation_active_item_max_width);
        this.activeItemMinWidth = res.getDimensionPixelSize(R.dimen.design_bottom_navigation_active_item_min_width);
        this.tempChildWidths = new int[5];
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        MenuBuilder menu = this.getMenu();
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int visibleCount = menu.getVisibleItems().size();
        int totalCount = this.getChildCount();
        int parentHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int heightSpec = View.MeasureSpec.makeMeasureSpec((int)parentHeight, (int)0x40000000);
        if (this.isShifting(this.getLabelVisibilityMode(), visibleCount) && this.isItemHorizontalTranslationEnabled()) {
            View activeChild = this.getChildAt(this.getSelectedItemPosition());
            int activeItemWidth = this.activeItemMinWidth;
            if (activeChild.getVisibility() != 8) {
                activeChild.measure(View.MeasureSpec.makeMeasureSpec((int)this.activeItemMaxWidth, (int)Integer.MIN_VALUE), heightSpec);
                activeItemWidth = Math.max(activeItemWidth, activeChild.getMeasuredWidth());
            }
            int inactiveCount = visibleCount - (activeChild.getVisibility() != 8 ? 1 : 0);
            int activeMaxAvailable = width - inactiveCount * this.inactiveItemMinWidth;
            int activeWidth = Math.min(activeMaxAvailable, Math.min(activeItemWidth, this.activeItemMaxWidth));
            int inactiveMaxAvailable = (width - activeWidth) / (inactiveCount == 0 ? 1 : inactiveCount);
            int inactiveWidth = Math.min(inactiveMaxAvailable, this.inactiveItemMaxWidth);
            int extra = width - activeWidth - inactiveWidth * inactiveCount;
            for (int i = 0; i < totalCount; ++i) {
                if (this.getChildAt(i).getVisibility() != 8) {
                    int n = this.tempChildWidths[i] = i == this.getSelectedItemPosition() ? activeWidth : inactiveWidth;
                    if (extra <= 0) continue;
                    int n2 = i;
                    this.tempChildWidths[n2] = this.tempChildWidths[n2] + 1;
                    --extra;
                    continue;
                }
                this.tempChildWidths[i] = 0;
            }
        } else {
            int maxAvailable = width / (visibleCount == 0 ? 1 : visibleCount);
            int childWidth = Math.min(maxAvailable, this.activeItemMaxWidth);
            int extra = width - childWidth * visibleCount;
            for (int i = 0; i < totalCount; ++i) {
                if (this.getChildAt(i).getVisibility() != 8) {
                    this.tempChildWidths[i] = childWidth;
                    if (extra <= 0) continue;
                    int n = i;
                    this.tempChildWidths[n] = this.tempChildWidths[n] + 1;
                    --extra;
                    continue;
                }
                this.tempChildWidths[i] = 0;
            }
        }
        int totalWidth = 0;
        for (int i = 0; i < totalCount; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            child.measure(View.MeasureSpec.makeMeasureSpec((int)this.tempChildWidths[i], (int)0x40000000), heightSpec);
            ViewGroup.LayoutParams params = child.getLayoutParams();
            params.width = child.getMeasuredWidth();
            totalWidth += child.getMeasuredWidth();
        }
        this.setMeasuredDimension(View.resolveSizeAndState((int)totalWidth, (int)View.MeasureSpec.makeMeasureSpec((int)totalWidth, (int)0x40000000), (int)0), View.resolveSizeAndState((int)parentHeight, (int)heightMeasureSpec, (int)0));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int count = this.getChildCount();
        int width = right - left;
        int height = bottom - top;
        int used = 0;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            if (ViewCompat.getLayoutDirection((View)this) == 1) {
                child.layout(width - used - child.getMeasuredWidth(), 0, width - used, height);
            } else {
                child.layout(used, 0, child.getMeasuredWidth() + used, height);
            }
            used += child.getMeasuredWidth();
        }
    }

    public void setItemHorizontalTranslationEnabled(boolean itemHorizontalTranslationEnabled) {
        this.itemHorizontalTranslationEnabled = itemHorizontalTranslationEnabled;
    }

    public boolean isItemHorizontalTranslationEnabled() {
        return this.itemHorizontalTranslationEnabled;
    }

    @Override
    @NonNull
    protected NavigationBarItemView createNavigationBarItemView(@NonNull Context context) {
        return new BottomNavigationItemView(context);
    }
}

