/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.util.pool;

import androidx.annotation.NonNull;

public abstract class StateVerifier {
    private static final boolean DEBUG = false;

    @NonNull
    public static StateVerifier newInstance() {
        return new DefaultStateVerifier();
    }

    private StateVerifier() {
    }

    public abstract void throwIfRecycled();

    abstract void setRecycled(boolean var1);

    private static class DebugStateVerifier
    extends StateVerifier {
        private volatile RuntimeException recycledAtStackTraceException;

        DebugStateVerifier() {
        }

        @Override
        public void throwIfRecycled() {
            if (this.recycledAtStackTraceException != null) {
                throw new IllegalStateException("Already released", this.recycledAtStackTraceException);
            }
        }

        @Override
        void setRecycled(boolean isRecycled) {
            this.recycledAtStackTraceException = isRecycled ? new RuntimeException("Released") : null;
        }
    }

    private static class DefaultStateVerifier
    extends StateVerifier {
        private volatile boolean isReleased;

        DefaultStateVerifier() {
        }

        @Override
        public void throwIfRecycled() {
            if (this.isReleased) {
                throw new IllegalStateException("Already released");
            }
        }

        @Override
        public void setRecycled(boolean isRecycled) {
            this.isReleased = isRecycled;
        }
    }
}

