/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.provider;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import com.bumptech.glide.util.MultiClassKey;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class ModelToResourceClassCache {
    private final AtomicReference<MultiClassKey> resourceClassKeyRef = new AtomicReference();
    private final ArrayMap<MultiClassKey, List<Class<?>>> registeredResourceClassCache = new ArrayMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<Class<?>> get(@NonNull Class<?> modelClass, @NonNull Class<?> resourceClass, @NonNull Class<?> transcodeClass) {
        List result;
        MultiClassKey key = this.resourceClassKeyRef.getAndSet(null);
        if (key == null) {
            key = new MultiClassKey(modelClass, resourceClass, transcodeClass);
        } else {
            key.set(modelClass, resourceClass, transcodeClass);
        }
        ArrayMap<MultiClassKey, List<Class<?>>> arrayMap = this.registeredResourceClassCache;
        synchronized (arrayMap) {
            result = (List)this.registeredResourceClassCache.get((Object)key);
        }
        this.resourceClassKeyRef.set(key);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(@NonNull Class<?> modelClass, @NonNull Class<?> resourceClass, @NonNull Class<?> transcodeClass, @NonNull List<Class<?>> resourceClasses) {
        ArrayMap<MultiClassKey, List<Class<?>>> arrayMap = this.registeredResourceClassCache;
        synchronized (arrayMap) {
            this.registeredResourceClassCache.put((Object)new MultiClassKey(modelClass, resourceClass, transcodeClass), resourceClasses);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ArrayMap<MultiClassKey, List<Class<?>>> arrayMap = this.registeredResourceClassCache;
        synchronized (arrayMap) {
            this.registeredResourceClassCache.clear();
        }
    }
}

