/*
 * Decompiled with CFR 0.152.
 */
package androidx.browser.trusted.sharing;

import android.net.Uri;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;

public final class ShareData {
    public static final String KEY_TITLE = "androidx.browser.trusted.sharing.KEY_TITLE";
    public static final String KEY_TEXT = "androidx.browser.trusted.sharing.KEY_TEXT";
    public static final String KEY_URIS = "androidx.browser.trusted.sharing.KEY_URIS";
    @Nullable
    public final String title;
    @Nullable
    public final String text;
    @Nullable
    public final List<Uri> uris;

    public ShareData(@Nullable String title, @Nullable String text, @Nullable List<Uri> uris) {
        this.title = title;
        this.text = text;
        this.uris = uris;
    }

    @NonNull
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putString(KEY_TITLE, this.title);
        bundle.putString(KEY_TEXT, this.text);
        if (this.uris != null) {
            bundle.putParcelableArrayList(KEY_URIS, new ArrayList<Uri>(this.uris));
        }
        return bundle;
    }

    @NonNull
    public static ShareData fromBundle(@NonNull Bundle bundle) {
        return new ShareData(bundle.getString(KEY_TITLE), bundle.getString(KEY_TEXT), bundle.getParcelableArrayList(KEY_URIS));
    }
}

