/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.app;

import android.app.Activity;
import android.app.Application;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
final class ActivityRecreator {
    private static final String LOG_TAG = "ActivityRecreator";
    protected static final Class<?> activityThreadClass;
    protected static final Field mainThreadField;
    protected static final Field tokenField;
    protected static final Method performStopActivity3ParamsMethod;
    protected static final Method performStopActivity2ParamsMethod;
    protected static final Method requestRelaunchActivityMethod;
    private static final Handler mainHandler;

    private ActivityRecreator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean recreate(@NonNull Activity activity) {
        boolean bl;
        if (Build.VERSION.SDK_INT >= 28) {
            activity.recreate();
            return true;
        }
        if (ActivityRecreator.needsRelaunchCall() && requestRelaunchActivityMethod == null) {
            return false;
        }
        if (performStopActivity2ParamsMethod == null && performStopActivity3ParamsMethod == null) {
            return false;
        }
        final Object token = tokenField.get(activity);
        if (token == null) {
            return false;
        }
        Object activityThread = mainThreadField.get(activity);
        if (activityThread == null) {
            return false;
        }
        Application application = activity.getApplication();
        final LifecycleCheckCallbacks callbacks = new LifecycleCheckCallbacks(activity);
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)callbacks);
        mainHandler.post(new Runnable(){

            @Override
            public void run() {
                callbacks.currentlyRecreatingToken = token;
            }
        });
        try {
            if (ActivityRecreator.needsRelaunchCall()) {
                requestRelaunchActivityMethod.invoke(activityThread, token, null, null, 0, false, null, null, false, false);
            } else {
                activity.recreate();
            }
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                mainHandler.post(new Runnable(application, callbacks){
                    final /* synthetic */ Application val$application;
                    final /* synthetic */ LifecycleCheckCallbacks val$callbacks;
                    {
                        this.val$application = application;
                        this.val$callbacks = lifecycleCheckCallbacks;
                    }

                    @Override
                    public void run() {
                        this.val$application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.val$callbacks);
                    }
                });
                throw throwable;
            }
            catch (Throwable t) {
                return false;
            }
        }
        mainHandler.post(new /* invalid duplicate definition of identical inner class */);
        return bl;
    }

    protected static boolean queueOnStopIfNecessary(Object currentlyRecreatingToken, int currentlyRecreatingHashCode, Activity activity) {
        try {
            final Object token = tokenField.get(activity);
            if (token != currentlyRecreatingToken || activity.hashCode() != currentlyRecreatingHashCode) {
                return false;
            }
            final Object activityThread = mainThreadField.get(activity);
            mainHandler.postAtFrontOfQueue(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (performStopActivity3ParamsMethod != null) {
                            performStopActivity3ParamsMethod.invoke(activityThread, token, false, "AppCompat recreation");
                        } else {
                            performStopActivity2ParamsMethod.invoke(activityThread, token, false);
                        }
                    }
                    catch (RuntimeException e) {
                        if (e.getClass() == RuntimeException.class && e.getMessage() != null && e.getMessage().startsWith("Unable to stop")) {
                            throw e;
                        }
                    }
                    catch (Throwable t) {
                        Log.e((String)ActivityRecreator.LOG_TAG, (String)"Exception while invoking performStopActivity", (Throwable)t);
                    }
                }
            });
            return true;
        }
        catch (Throwable t) {
            Log.e((String)LOG_TAG, (String)"Exception while fetching field values", (Throwable)t);
            return false;
        }
    }

    private static Method getPerformStopActivity3Params(Class<?> activityThreadClass) {
        if (activityThreadClass == null) {
            return null;
        }
        try {
            Method performStop = activityThreadClass.getDeclaredMethod("performStopActivity", IBinder.class, Boolean.TYPE, String.class);
            performStop.setAccessible(true);
            return performStop;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static Method getPerformStopActivity2Params(Class<?> activityThreadClass) {
        if (activityThreadClass == null) {
            return null;
        }
        try {
            Method performStop = activityThreadClass.getDeclaredMethod("performStopActivity", IBinder.class, Boolean.TYPE);
            performStop.setAccessible(true);
            return performStop;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static boolean needsRelaunchCall() {
        return Build.VERSION.SDK_INT == 26 || Build.VERSION.SDK_INT == 27;
    }

    private static Method getRequestRelaunchActivityMethod(Class<?> activityThreadClass) {
        if (!ActivityRecreator.needsRelaunchCall() || activityThreadClass == null) {
            return null;
        }
        try {
            Method relaunch = activityThreadClass.getDeclaredMethod("requestRelaunchActivity", IBinder.class, List.class, List.class, Integer.TYPE, Boolean.TYPE, Configuration.class, Configuration.class, Boolean.TYPE, Boolean.TYPE);
            relaunch.setAccessible(true);
            return relaunch;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static Field getMainThreadField() {
        try {
            Field mainThreadField = Activity.class.getDeclaredField("mMainThread");
            mainThreadField.setAccessible(true);
            return mainThreadField;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static Field getTokenField() {
        try {
            Field tokenField = Activity.class.getDeclaredField("mToken");
            tokenField.setAccessible(true);
            return tokenField;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static Class<?> getActivityThreadClass() {
        try {
            return Class.forName("android.app.ActivityThread");
        }
        catch (Throwable t) {
            return null;
        }
    }

    static {
        mainHandler = new Handler(Looper.getMainLooper());
        activityThreadClass = ActivityRecreator.getActivityThreadClass();
        mainThreadField = ActivityRecreator.getMainThreadField();
        tokenField = ActivityRecreator.getTokenField();
        performStopActivity3ParamsMethod = ActivityRecreator.getPerformStopActivity3Params(activityThreadClass);
        performStopActivity2ParamsMethod = ActivityRecreator.getPerformStopActivity2Params(activityThreadClass);
        requestRelaunchActivityMethod = ActivityRecreator.getRequestRelaunchActivityMethod(activityThreadClass);
    }

    private static final class LifecycleCheckCallbacks
    implements Application.ActivityLifecycleCallbacks {
        Object currentlyRecreatingToken;
        private Activity mActivity;
        private final int mRecreatingHashCode;
        private boolean mStarted = false;
        private boolean mDestroyed = false;
        private boolean mStopQueued = false;

        LifecycleCheckCallbacks(@NonNull Activity aboutToRecreate) {
            this.mActivity = aboutToRecreate;
            this.mRecreatingHashCode = this.mActivity.hashCode();
        }

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        }

        public void onActivityStarted(Activity activity) {
            if (this.mActivity == activity) {
                this.mStarted = true;
            }
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
            if (this.mDestroyed && !this.mStopQueued && !this.mStarted && ActivityRecreator.queueOnStopIfNecessary(this.currentlyRecreatingToken, this.mRecreatingHashCode, activity)) {
                this.mStopQueued = true;
                this.currentlyRecreatingToken = null;
            }
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        public void onActivityStopped(Activity activity) {
        }

        public void onActivityDestroyed(Activity activity) {
            if (this.mActivity == activity) {
                this.mActivity = null;
                this.mDestroyed = true;
            }
        }
    }
}

