/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.request;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.util.Log;
import androidx.annotation.DrawableRes;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.GlideBuilder;
import com.bumptech.glide.GlideContext;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.Engine;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.resource.drawable.DrawableDecoderCompat;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.Request;
import com.bumptech.glide.request.RequestCoordinator;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.ResourceCallback;
import com.bumptech.glide.request.target.SizeReadyCallback;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.bumptech.glide.request.transition.TransitionFactory;
import com.bumptech.glide.util.LogTime;
import com.bumptech.glide.util.Util;
import com.bumptech.glide.util.pool.StateVerifier;
import java.util.List;
import java.util.concurrent.Executor;

public final class SingleRequest<R>
implements Request,
SizeReadyCallback,
ResourceCallback {
    private static final String TAG = "Request";
    private static final String GLIDE_TAG = "Glide";
    private static final boolean IS_VERBOSE_LOGGABLE = Log.isLoggable((String)"Request", (int)2);
    @Nullable
    private final String tag = IS_VERBOSE_LOGGABLE ? String.valueOf(super.hashCode()) : null;
    private final StateVerifier stateVerifier = StateVerifier.newInstance();
    private final Object requestLock;
    @Nullable
    private final RequestListener<R> targetListener;
    private final RequestCoordinator requestCoordinator;
    private final Context context;
    private final GlideContext glideContext;
    @Nullable
    private final Object model;
    private final Class<R> transcodeClass;
    private final BaseRequestOptions<?> requestOptions;
    private final int overrideWidth;
    private final int overrideHeight;
    private final Priority priority;
    private final Target<R> target;
    @Nullable
    private final List<RequestListener<R>> requestListeners;
    private final TransitionFactory<? super R> animationFactory;
    private final Executor callbackExecutor;
    @GuardedBy(value="requestLock")
    private Resource<R> resource;
    @GuardedBy(value="requestLock")
    private Engine.LoadStatus loadStatus;
    @GuardedBy(value="requestLock")
    private long startTime;
    private volatile Engine engine;
    @GuardedBy(value="requestLock")
    private Status status;
    @GuardedBy(value="requestLock")
    @Nullable
    private Drawable errorDrawable;
    @GuardedBy(value="requestLock")
    @Nullable
    private Drawable placeholderDrawable;
    @GuardedBy(value="requestLock")
    @Nullable
    private Drawable fallbackDrawable;
    @GuardedBy(value="requestLock")
    private int width;
    @GuardedBy(value="requestLock")
    private int height;
    @GuardedBy(value="requestLock")
    private boolean isCallingCallbacks;
    @Nullable
    private RuntimeException requestOrigin;

    public static <R> SingleRequest<R> obtain(Context context, GlideContext glideContext, Object requestLock, Object model, Class<R> transcodeClass, BaseRequestOptions<?> requestOptions, int overrideWidth, int overrideHeight, Priority priority, Target<R> target, RequestListener<R> targetListener, @Nullable List<RequestListener<R>> requestListeners, RequestCoordinator requestCoordinator, Engine engine, TransitionFactory<? super R> animationFactory, Executor callbackExecutor) {
        return new SingleRequest<R>(context, glideContext, requestLock, model, transcodeClass, requestOptions, overrideWidth, overrideHeight, priority, target, targetListener, requestListeners, requestCoordinator, engine, animationFactory, callbackExecutor);
    }

    private SingleRequest(Context context, GlideContext glideContext, @NonNull Object requestLock, @Nullable Object model, Class<R> transcodeClass, BaseRequestOptions<?> requestOptions, int overrideWidth, int overrideHeight, Priority priority, Target<R> target, @Nullable RequestListener<R> targetListener, @Nullable List<RequestListener<R>> requestListeners, RequestCoordinator requestCoordinator, Engine engine, TransitionFactory<? super R> animationFactory, Executor callbackExecutor) {
        this.requestLock = requestLock;
        this.context = context;
        this.glideContext = glideContext;
        this.model = model;
        this.transcodeClass = transcodeClass;
        this.requestOptions = requestOptions;
        this.overrideWidth = overrideWidth;
        this.overrideHeight = overrideHeight;
        this.priority = priority;
        this.target = target;
        this.targetListener = targetListener;
        this.requestListeners = requestListeners;
        this.requestCoordinator = requestCoordinator;
        this.engine = engine;
        this.animationFactory = animationFactory;
        this.callbackExecutor = callbackExecutor;
        this.status = Status.PENDING;
        if (this.requestOrigin == null && glideContext.getExperiments().isEnabled(GlideBuilder.LogRequestOrigins.class)) {
            this.requestOrigin = new RuntimeException("Glide request origin trace");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void begin() {
        Object object = this.requestLock;
        synchronized (object) {
            this.assertNotCallingCallbacks();
            this.stateVerifier.throwIfRecycled();
            this.startTime = LogTime.getLogTime();
            if (this.model == null) {
                if (Util.isValidDimensions(this.overrideWidth, this.overrideHeight)) {
                    this.width = this.overrideWidth;
                    this.height = this.overrideHeight;
                }
                int logLevel = this.getFallbackDrawable() == null ? 5 : 3;
                this.onLoadFailed(new GlideException("Received null model"), logLevel);
                return;
            }
            if (this.status == Status.RUNNING) {
                throw new IllegalArgumentException("Cannot restart a running request");
            }
            if (this.status == Status.COMPLETE) {
                this.onResourceReady(this.resource, DataSource.MEMORY_CACHE, false);
                return;
            }
            this.status = Status.WAITING_FOR_SIZE;
            if (Util.isValidDimensions(this.overrideWidth, this.overrideHeight)) {
                this.onSizeReady(this.overrideWidth, this.overrideHeight);
            } else {
                this.target.getSize(this);
            }
            if ((this.status == Status.RUNNING || this.status == Status.WAITING_FOR_SIZE) && this.canNotifyStatusChanged()) {
                this.target.onLoadStarted(this.getPlaceholderDrawable());
            }
            if (IS_VERBOSE_LOGGABLE) {
                this.logV("finished run method in " + LogTime.getElapsedMillis(this.startTime));
            }
        }
    }

    @GuardedBy(value="requestLock")
    private void cancel() {
        this.assertNotCallingCallbacks();
        this.stateVerifier.throwIfRecycled();
        this.target.removeCallback(this);
        if (this.loadStatus != null) {
            this.loadStatus.cancel();
            this.loadStatus = null;
        }
    }

    @GuardedBy(value="requestLock")
    private void assertNotCallingCallbacks() {
        if (this.isCallingCallbacks) {
            throw new IllegalStateException("You can't start or clear loads in RequestListener or Target callbacks. If you're trying to start a fallback request when a load fails, use RequestBuilder#error(RequestBuilder). Otherwise consider posting your into() or clear() calls to the main thread using a Handler instead.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Resource<R> toRelease = null;
        Object object = this.requestLock;
        synchronized (object) {
            this.assertNotCallingCallbacks();
            this.stateVerifier.throwIfRecycled();
            if (this.status == Status.CLEARED) {
                return;
            }
            this.cancel();
            if (this.resource != null) {
                toRelease = this.resource;
                this.resource = null;
            }
            if (this.canNotifyCleared()) {
                this.target.onLoadCleared(this.getPlaceholderDrawable());
            }
            this.status = Status.CLEARED;
        }
        if (toRelease != null) {
            this.engine.release(toRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        Object object = this.requestLock;
        synchronized (object) {
            if (this.isRunning()) {
                this.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRunning() {
        Object object = this.requestLock;
        synchronized (object) {
            return this.status == Status.RUNNING || this.status == Status.WAITING_FOR_SIZE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isComplete() {
        Object object = this.requestLock;
        synchronized (object) {
            return this.status == Status.COMPLETE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCleared() {
        Object object = this.requestLock;
        synchronized (object) {
            return this.status == Status.CLEARED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAnyResourceSet() {
        Object object = this.requestLock;
        synchronized (object) {
            return this.status == Status.COMPLETE;
        }
    }

    @GuardedBy(value="requestLock")
    private Drawable getErrorDrawable() {
        if (this.errorDrawable == null) {
            this.errorDrawable = this.requestOptions.getErrorPlaceholder();
            if (this.errorDrawable == null && this.requestOptions.getErrorId() > 0) {
                this.errorDrawable = this.loadDrawable(this.requestOptions.getErrorId());
            }
        }
        return this.errorDrawable;
    }

    @GuardedBy(value="requestLock")
    private Drawable getPlaceholderDrawable() {
        if (this.placeholderDrawable == null) {
            this.placeholderDrawable = this.requestOptions.getPlaceholderDrawable();
            if (this.placeholderDrawable == null && this.requestOptions.getPlaceholderId() > 0) {
                this.placeholderDrawable = this.loadDrawable(this.requestOptions.getPlaceholderId());
            }
        }
        return this.placeholderDrawable;
    }

    @GuardedBy(value="requestLock")
    private Drawable getFallbackDrawable() {
        if (this.fallbackDrawable == null) {
            this.fallbackDrawable = this.requestOptions.getFallbackDrawable();
            if (this.fallbackDrawable == null && this.requestOptions.getFallbackId() > 0) {
                this.fallbackDrawable = this.loadDrawable(this.requestOptions.getFallbackId());
            }
        }
        return this.fallbackDrawable;
    }

    @GuardedBy(value="requestLock")
    private Drawable loadDrawable(@DrawableRes int resourceId) {
        Resources.Theme theme = this.requestOptions.getTheme() != null ? this.requestOptions.getTheme() : this.context.getTheme();
        return DrawableDecoderCompat.getDrawable((Context)this.glideContext, resourceId, theme);
    }

    @GuardedBy(value="requestLock")
    private void setErrorPlaceholder() {
        if (!this.canNotifyStatusChanged()) {
            return;
        }
        Drawable error = null;
        if (this.model == null) {
            error = this.getFallbackDrawable();
        }
        if (error == null) {
            error = this.getErrorDrawable();
        }
        if (error == null) {
            error = this.getPlaceholderDrawable();
        }
        this.target.onLoadFailed(error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSizeReady(int width, int height) {
        this.stateVerifier.throwIfRecycled();
        Object object = this.requestLock;
        synchronized (object) {
            if (IS_VERBOSE_LOGGABLE) {
                this.logV("Got onSizeReady in " + LogTime.getElapsedMillis(this.startTime));
            }
            if (this.status != Status.WAITING_FOR_SIZE) {
                return;
            }
            this.status = Status.RUNNING;
            float sizeMultiplier = this.requestOptions.getSizeMultiplier();
            this.width = SingleRequest.maybeApplySizeMultiplier(width, sizeMultiplier);
            this.height = SingleRequest.maybeApplySizeMultiplier(height, sizeMultiplier);
            if (IS_VERBOSE_LOGGABLE) {
                this.logV("finished setup for calling load in " + LogTime.getElapsedMillis(this.startTime));
            }
            this.loadStatus = this.engine.load(this.glideContext, this.model, this.requestOptions.getSignature(), this.width, this.height, this.requestOptions.getResourceClass(), this.transcodeClass, this.priority, this.requestOptions.getDiskCacheStrategy(), this.requestOptions.getTransformations(), this.requestOptions.isTransformationRequired(), this.requestOptions.isScaleOnlyOrNoTransform(), this.requestOptions.getOptions(), this.requestOptions.isMemoryCacheable(), this.requestOptions.getUseUnlimitedSourceGeneratorsPool(), this.requestOptions.getUseAnimationPool(), this.requestOptions.getOnlyRetrieveFromCache(), this, this.callbackExecutor);
            if (this.status != Status.RUNNING) {
                this.loadStatus = null;
            }
            if (IS_VERBOSE_LOGGABLE) {
                this.logV("finished onSizeReady in " + LogTime.getElapsedMillis(this.startTime));
            }
        }
    }

    private static int maybeApplySizeMultiplier(int size, float sizeMultiplier) {
        return size == Integer.MIN_VALUE ? size : Math.round(sizeMultiplier * (float)size);
    }

    @GuardedBy(value="requestLock")
    private boolean canSetResource() {
        return this.requestCoordinator == null || this.requestCoordinator.canSetImage(this);
    }

    @GuardedBy(value="requestLock")
    private boolean canNotifyCleared() {
        return this.requestCoordinator == null || this.requestCoordinator.canNotifyCleared(this);
    }

    @GuardedBy(value="requestLock")
    private boolean canNotifyStatusChanged() {
        return this.requestCoordinator == null || this.requestCoordinator.canNotifyStatusChanged(this);
    }

    @GuardedBy(value="requestLock")
    private boolean isFirstReadyResource() {
        return this.requestCoordinator == null || !this.requestCoordinator.getRoot().isAnyResourceSet();
    }

    @GuardedBy(value="requestLock")
    private void notifyLoadSuccess() {
        if (this.requestCoordinator != null) {
            this.requestCoordinator.onRequestSuccess(this);
        }
    }

    @GuardedBy(value="requestLock")
    private void notifyLoadFailed() {
        if (this.requestCoordinator != null) {
            this.requestCoordinator.onRequestFailed(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void onResourceReady(Resource<?> resource, DataSource dataSource, boolean isLoadedFromAlternateCacheKey) {
        Object received;
        Resource<?> toRelease;
        block12: {
            this.stateVerifier.throwIfRecycled();
            toRelease = null;
            Object object = this.requestLock;
            // MONITORENTER : object
            this.loadStatus = null;
            if (resource == null) {
                GlideException exception = new GlideException("Expected to receive a Resource<R> with an object of " + this.transcodeClass + " inside, but instead got null.");
                this.onLoadFailed(exception);
                // MONITOREXIT : object
                if (toRelease == null) return;
                this.engine.release(toRelease);
                return;
            }
            received = resource.get();
            if (received != null && this.transcodeClass.isAssignableFrom(received.getClass())) break block12;
            toRelease = resource;
            this.resource = null;
            GlideException exception = new GlideException("Expected to receive an object of " + this.transcodeClass + " but instead got " + (received != null ? received.getClass() : "") + "{" + received + "} inside Resource{" + resource + "}." + (received != null ? "" : " To indicate failure return a null Resource object, rather than a Resource object containing null data."));
            this.onLoadFailed(exception);
            if (toRelease == null) return;
            this.engine.release(toRelease);
            return;
        }
        if (!this.canSetResource()) {
            toRelease = resource;
            this.resource = null;
            this.status = Status.COMPLETE;
            // MONITOREXIT : object
            if (toRelease == null) return;
            this.engine.release(toRelease);
            return;
        }
        try {
            this.onResourceReady(resource, received, dataSource, isLoadedFromAlternateCacheKey);
            // MONITOREXIT : object
            return;
        }
        finally {
            if (toRelease != null) {
                this.engine.release(toRelease);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="requestLock")
    private void onResourceReady(Resource<R> resource, R result, DataSource dataSource, boolean isAlternateCacheKey) {
        boolean isFirstResource = this.isFirstReadyResource();
        this.status = Status.COMPLETE;
        this.resource = resource;
        if (this.glideContext.getLogLevel() <= 3) {
            Log.d((String)GLIDE_TAG, (String)("Finished loading " + result.getClass().getSimpleName() + " from " + (Object)((Object)dataSource) + " for " + this.model + " with size [" + this.width + "x" + this.height + "] in " + LogTime.getElapsedMillis(this.startTime) + " ms"));
        }
        this.isCallingCallbacks = true;
        try {
            boolean anyListenerHandledUpdatingTarget = false;
            if (this.requestListeners != null) {
                for (RequestListener<R> listener : this.requestListeners) {
                    anyListenerHandledUpdatingTarget |= listener.onResourceReady(result, this.model, this.target, dataSource, isFirstResource);
                }
            }
            if (!(anyListenerHandledUpdatingTarget |= this.targetListener != null && this.targetListener.onResourceReady(result, this.model, this.target, dataSource, isFirstResource))) {
                Transition<? super R> animation = this.animationFactory.build(dataSource, isFirstResource);
                this.target.onResourceReady((R)result, animation);
            }
        }
        finally {
            this.isCallingCallbacks = false;
        }
        this.notifyLoadSuccess();
    }

    @Override
    public void onLoadFailed(GlideException e) {
        this.onLoadFailed(e, 5);
    }

    @Override
    public Object getLock() {
        this.stateVerifier.throwIfRecycled();
        return this.requestLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onLoadFailed(GlideException e, int maxLogLevel) {
        this.stateVerifier.throwIfRecycled();
        Object object = this.requestLock;
        synchronized (object) {
            e.setOrigin(this.requestOrigin);
            int logLevel = this.glideContext.getLogLevel();
            if (logLevel <= maxLogLevel) {
                Log.w((String)GLIDE_TAG, (String)("Load failed for " + this.model + " with size [" + this.width + "x" + this.height + "]"), (Throwable)e);
                if (logLevel <= 4) {
                    e.logRootCauses(GLIDE_TAG);
                }
            }
            this.loadStatus = null;
            this.status = Status.FAILED;
            this.isCallingCallbacks = true;
            try {
                boolean anyListenerHandledUpdatingTarget = false;
                if (this.requestListeners != null) {
                    for (RequestListener<R> listener : this.requestListeners) {
                        anyListenerHandledUpdatingTarget |= listener.onLoadFailed(e, this.model, this.target, this.isFirstReadyResource());
                    }
                }
                if (!(anyListenerHandledUpdatingTarget |= this.targetListener != null && this.targetListener.onLoadFailed(e, this.model, this.target, this.isFirstReadyResource()))) {
                    this.setErrorPlaceholder();
                }
            }
            finally {
                this.isCallingCallbacks = false;
            }
            this.notifyLoadFailed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEquivalentTo(Request o) {
        int otherLocalListenerCount;
        Priority otherLocalPriority;
        BaseRequestOptions<?> otherLocalRequestOptions;
        Class<R> otherLocalTransocdeClass;
        Object otherLocalModel;
        int otherLocalOverrideHeight;
        int otherLocalOverrideWidth;
        int localListenerCount;
        Priority localPriority;
        BaseRequestOptions<?> localRequestOptions;
        Class<R> localTransocdeClass;
        Object localModel;
        int localOverrideHeight;
        int localOverrideWidth;
        if (!(o instanceof SingleRequest)) {
            return false;
        }
        Object object = this.requestLock;
        synchronized (object) {
            localOverrideWidth = this.overrideWidth;
            localOverrideHeight = this.overrideHeight;
            localModel = this.model;
            localTransocdeClass = this.transcodeClass;
            localRequestOptions = this.requestOptions;
            localPriority = this.priority;
            localListenerCount = this.requestListeners != null ? this.requestListeners.size() : 0;
        }
        SingleRequest other = (SingleRequest)o;
        Object object2 = other.requestLock;
        synchronized (object2) {
            otherLocalOverrideWidth = other.overrideWidth;
            otherLocalOverrideHeight = other.overrideHeight;
            otherLocalModel = other.model;
            otherLocalTransocdeClass = other.transcodeClass;
            otherLocalRequestOptions = other.requestOptions;
            otherLocalPriority = other.priority;
            otherLocalListenerCount = other.requestListeners != null ? other.requestListeners.size() : 0;
        }
        return localOverrideWidth == otherLocalOverrideWidth && localOverrideHeight == otherLocalOverrideHeight && Util.bothModelsNullEquivalentOrEquals(localModel, otherLocalModel) && localTransocdeClass.equals(otherLocalTransocdeClass) && localRequestOptions.equals(otherLocalRequestOptions) && localPriority == otherLocalPriority && localListenerCount == otherLocalListenerCount;
    }

    private void logV(String message) {
        Log.v((String)TAG, (String)(message + " this: " + this.tag));
    }

    private static enum Status {
        PENDING,
        RUNNING,
        WAITING_FOR_SIZE,
        COMPLETE,
        FAILED,
        CLEARED;

    }
}

