/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.manager;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import com.bumptech.glide.manager.ConnectivityMonitor;
import com.bumptech.glide.manager.ConnectivityMonitorFactory;
import com.bumptech.glide.manager.DefaultConnectivityMonitor;
import com.bumptech.glide.manager.NullConnectivityMonitor;

public class DefaultConnectivityMonitorFactory
implements ConnectivityMonitorFactory {
    private static final String TAG = "ConnectivityMonitor";
    private static final String NETWORK_PERMISSION = "android.permission.ACCESS_NETWORK_STATE";

    @Override
    @NonNull
    public ConnectivityMonitor build(@NonNull Context context, @NonNull ConnectivityMonitor.ConnectivityListener listener) {
        boolean hasPermission;
        int permissionResult = ContextCompat.checkSelfPermission((Context)context, (String)NETWORK_PERMISSION);
        boolean bl = hasPermission = permissionResult == 0;
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)(hasPermission ? "ACCESS_NETWORK_STATE permission granted, registering connectivity monitor" : "ACCESS_NETWORK_STATE permission missing, cannot register connectivity monitor"));
        }
        return hasPermission ? new DefaultConnectivityMonitor(context, listener) : new NullConnectivityMonitor();
    }
}

