/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.request.target;

import android.graphics.drawable.Drawable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.request.Request;
import com.bumptech.glide.request.target.SizeReadyCallback;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.util.Util;

public abstract class CustomTarget<T>
implements Target<T> {
    private final int width;
    private final int height;
    @Nullable
    private Request request;

    public CustomTarget() {
        this(Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public CustomTarget(int width, int height) {
        if (!Util.isValidDimensions(width, height)) {
            throw new IllegalArgumentException("Width and height must both be > 0 or Target#SIZE_ORIGINAL, but given width: " + width + " and height: " + height);
        }
        this.width = width;
        this.height = height;
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onStop() {
    }

    @Override
    public void onDestroy() {
    }

    @Override
    public void onLoadStarted(@Nullable Drawable placeholder) {
    }

    @Override
    public void onLoadFailed(@Nullable Drawable errorDrawable) {
    }

    @Override
    public final void getSize(@NonNull SizeReadyCallback cb) {
        cb.onSizeReady(this.width, this.height);
    }

    @Override
    public final void removeCallback(@NonNull SizeReadyCallback cb) {
    }

    @Override
    public final void setRequest(@Nullable Request request) {
        this.request = request;
    }

    @Override
    @Nullable
    public final Request getRequest() {
        return this.request;
    }
}

